package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.TapeARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RetrieveTapeArchiveResponse(tapeARN: Option[TapeARN] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.RetrieveTapeArchiveResponse = {
    import RetrieveTapeArchiveResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.RetrieveTapeArchiveResponse
      .builder()
      .optionallyWith(
        tapeARN.map(value => TapeARN.unwrap(value): java.lang.String)
      )(_.tapeARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.RetrieveTapeArchiveResponse.ReadOnly =
    zio.aws.storagegateway.model.RetrieveTapeArchiveResponse
      .wrap(buildAwsValue())
}
object RetrieveTapeArchiveResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.RetrieveTapeArchiveResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.RetrieveTapeArchiveResponse =
      zio.aws.storagegateway.model
        .RetrieveTapeArchiveResponse(tapeARN.map(value => value))
    def tapeARN: Option[TapeARN]
    def getTapeARN: ZIO[Any, AwsError, TapeARN] =
      AwsError.unwrapOptionField("tapeARN", tapeARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.RetrieveTapeArchiveResponse
  ) extends zio.aws.storagegateway.model.RetrieveTapeArchiveResponse.ReadOnly {
    override val tapeARN: Option[TapeARN] = scala
      .Option(impl.tapeARN())
      .map(value => zio.aws.storagegateway.model.primitives.TapeARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.RetrieveTapeArchiveResponse
  ): zio.aws.storagegateway.model.RetrieveTapeArchiveResponse.ReadOnly =
    new Wrapper(impl)
}
