package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.Initiator
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListVolumeInitiatorsResponse(
    initiators: Option[Iterable[Initiator]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListVolumeInitiatorsResponse = {
    import ListVolumeInitiatorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListVolumeInitiatorsResponse
      .builder()
      .optionallyWith(
        initiators.map(value =>
          value.map { item =>
            Initiator.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.initiators)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.ListVolumeInitiatorsResponse.ReadOnly =
    zio.aws.storagegateway.model.ListVolumeInitiatorsResponse
      .wrap(buildAwsValue())
}
object ListVolumeInitiatorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListVolumeInitiatorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ListVolumeInitiatorsResponse =
      zio.aws.storagegateway.model
        .ListVolumeInitiatorsResponse(initiators.map(value => value))
    def initiators: Option[List[Initiator]]
    def getInitiators: ZIO[Any, AwsError, List[Initiator]] =
      AwsError.unwrapOptionField("initiators", initiators)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListVolumeInitiatorsResponse
  ) extends zio.aws.storagegateway.model.ListVolumeInitiatorsResponse.ReadOnly {
    override val initiators: Option[List[Initiator]] = scala
      .Option(impl.initiators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.primitives.Initiator(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListVolumeInitiatorsResponse
  ): zio.aws.storagegateway.model.ListVolumeInitiatorsResponse.ReadOnly =
    new Wrapper(impl)
}
