package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  GatewayARN,
  FileSystemAssociationStatus,
  FileSystemAssociationARN,
  FileSystemAssociationId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class FileSystemAssociationSummary(
    fileSystemAssociationId: Option[FileSystemAssociationId] = None,
    fileSystemAssociationARN: Option[FileSystemAssociationARN] = None,
    fileSystemAssociationStatus: Option[FileSystemAssociationStatus] = None,
    gatewayARN: Option[GatewayARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationSummary = {
    import FileSystemAssociationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationSummary
      .builder()
      .optionallyWith(
        fileSystemAssociationId.map(value =>
          FileSystemAssociationId.unwrap(value): java.lang.String
        )
      )(_.fileSystemAssociationId)
      .optionallyWith(
        fileSystemAssociationARN.map(value =>
          FileSystemAssociationARN.unwrap(value): java.lang.String
        )
      )(_.fileSystemAssociationARN)
      .optionallyWith(
        fileSystemAssociationStatus.map(value =>
          FileSystemAssociationStatus.unwrap(value): java.lang.String
        )
      )(_.fileSystemAssociationStatus)
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.FileSystemAssociationSummary.ReadOnly =
    zio.aws.storagegateway.model.FileSystemAssociationSummary
      .wrap(buildAwsValue())
}
object FileSystemAssociationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.FileSystemAssociationSummary =
      zio.aws.storagegateway.model.FileSystemAssociationSummary(
        fileSystemAssociationId.map(value => value),
        fileSystemAssociationARN.map(value => value),
        fileSystemAssociationStatus.map(value => value),
        gatewayARN.map(value => value)
      )
    def fileSystemAssociationId: Option[FileSystemAssociationId]
    def fileSystemAssociationARN: Option[FileSystemAssociationARN]
    def fileSystemAssociationStatus: Option[FileSystemAssociationStatus]
    def gatewayARN: Option[GatewayARN]
    def getFileSystemAssociationId
        : ZIO[Any, AwsError, FileSystemAssociationId] = AwsError
      .unwrapOptionField("fileSystemAssociationId", fileSystemAssociationId)
    def getFileSystemAssociationARN
        : ZIO[Any, AwsError, FileSystemAssociationARN] = AwsError
      .unwrapOptionField("fileSystemAssociationARN", fileSystemAssociationARN)
    def getFileSystemAssociationStatus
        : ZIO[Any, AwsError, FileSystemAssociationStatus] =
      AwsError.unwrapOptionField(
        "fileSystemAssociationStatus",
        fileSystemAssociationStatus
      )
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationSummary
  ) extends zio.aws.storagegateway.model.FileSystemAssociationSummary.ReadOnly {
    override val fileSystemAssociationId: Option[FileSystemAssociationId] =
      scala
        .Option(impl.fileSystemAssociationId())
        .map(value =>
          zio.aws.storagegateway.model.primitives.FileSystemAssociationId(value)
        )
    override val fileSystemAssociationARN: Option[FileSystemAssociationARN] =
      scala
        .Option(impl.fileSystemAssociationARN())
        .map(value =>
          zio.aws.storagegateway.model.primitives
            .FileSystemAssociationARN(value)
        )
    override val fileSystemAssociationStatus
        : Option[FileSystemAssociationStatus] = scala
      .Option(impl.fileSystemAssociationStatus())
      .map(value =>
        zio.aws.storagegateway.model.primitives
          .FileSystemAssociationStatus(value)
      )
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationSummary
  ): zio.aws.storagegateway.model.FileSystemAssociationSummary.ReadOnly =
    new Wrapper(impl)
}
