package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{Marker, GatewayARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeVtlDevicesResponse(
    gatewayARN: Option[GatewayARN] = None,
    vtlDevices: Option[Iterable[zio.aws.storagegateway.model.VTLDevice]] = None,
    marker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesResponse = {
    import DescribeVtlDevicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        vtlDevices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vtlDevices)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeVtlDevicesResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeVtlDevicesResponse
      .wrap(buildAwsValue())
}
object DescribeVtlDevicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DescribeVtlDevicesResponse =
      zio.aws.storagegateway.model.DescribeVtlDevicesResponse(
        gatewayARN.map(value => value),
        vtlDevices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def gatewayARN: Option[GatewayARN]
    def vtlDevices
        : Option[List[zio.aws.storagegateway.model.VTLDevice.ReadOnly]]
    def marker: Option[Marker]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getVtlDevices: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.VTLDevice.ReadOnly
    ]] = AwsError.unwrapOptionField("vtlDevices", vtlDevices)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesResponse
  ) extends zio.aws.storagegateway.model.DescribeVtlDevicesResponse.ReadOnly {
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val vtlDevices
        : Option[List[zio.aws.storagegateway.model.VTLDevice.ReadOnly]] = scala
      .Option(impl.vtlDevices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.VTLDevice.wrap(item)
        }.toList
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesResponse
  ): zio.aws.storagegateway.model.DescribeVtlDevicesResponse.ReadOnly =
    new Wrapper(impl)
}
