package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeTapesResponse(
    tapes: Option[Iterable[zio.aws.storagegateway.model.Tape]] = None,
    marker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeTapesResponse = {
    import DescribeTapesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeTapesResponse
      .builder()
      .optionallyWith(
        tapes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tapes)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.DescribeTapesResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeTapesResponse.wrap(buildAwsValue())
}
object DescribeTapesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeTapesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DescribeTapesResponse =
      zio.aws.storagegateway.model.DescribeTapesResponse(
        tapes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def tapes: Option[List[zio.aws.storagegateway.model.Tape.ReadOnly]]
    def marker: Option[Marker]
    def getTapes
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Tape.ReadOnly]] =
      AwsError.unwrapOptionField("tapes", tapes)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeTapesResponse
  ) extends zio.aws.storagegateway.model.DescribeTapesResponse.ReadOnly {
    override val tapes
        : Option[List[zio.aws.storagegateway.model.Tape.ReadOnly]] = scala
      .Option(impl.tapes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.Tape.wrap(item)
        }.toList
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeTapesResponse
  ): zio.aws.storagegateway.model.DescribeTapesResponse.ReadOnly = new Wrapper(
    impl
  )
}
