package zio.aws.storagegateway.model
import java.lang.Integer
import zio.aws.storagegateway.model.primitives.{
  PositiveIntObject,
  Marker,
  GatewayARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeTapeRecoveryPointsRequest(
    gatewayARN: GatewayARN,
    marker: Option[Marker] = None,
    limit: Option[PositiveIntObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest = {
    import DescribeTapeRecoveryPointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        limit.map(value => PositiveIntObject.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeTapeRecoveryPointsRequest.ReadOnly =
    zio.aws.storagegateway.model.DescribeTapeRecoveryPointsRequest
      .wrap(buildAwsValue())
}
object DescribeTapeRecoveryPointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeTapeRecoveryPointsRequest =
      zio.aws.storagegateway.model.DescribeTapeRecoveryPointsRequest(
        gatewayARN,
        marker.map(value => value),
        limit.map(value => value)
      )
    def gatewayARN: GatewayARN
    def marker: Option[Marker]
    def limit: Option[PositiveIntObject]
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getLimit: ZIO[Any, AwsError, PositiveIntObject] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest
  ) extends zio.aws.storagegateway.model.DescribeTapeRecoveryPointsRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
    override val limit: Option[PositiveIntObject] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.storagegateway.model.primitives.PositiveIntObject(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest
  ): zio.aws.storagegateway.model.DescribeTapeRecoveryPointsRequest.ReadOnly =
    new Wrapper(impl)
}
