package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{DomainName, GatewayARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSmbSettingsResponse(
    gatewayARN: Option[GatewayARN] = None,
    domainName: Option[DomainName] = None,
    activeDirectoryStatus: Option[
      zio.aws.storagegateway.model.ActiveDirectoryStatus
    ] = None,
    smbGuestPasswordSet: Option[Boolean] = None,
    smbSecurityStrategy: Option[
      zio.aws.storagegateway.model.SMBSecurityStrategy
    ] = None,
    fileSharesVisible: Option[Boolean] = None,
    smbLocalGroups: Option[zio.aws.storagegateway.model.SMBLocalGroups] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeSmbSettingsResponse = {
    import DescribeSmbSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeSmbSettingsResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(activeDirectoryStatus.map(value => value.unwrap))(
        _.activeDirectoryStatus
      )
      .optionallyWith(
        smbGuestPasswordSet.map(value => value: java.lang.Boolean)
      )(_.smbGuestPasswordSet)
      .optionallyWith(smbSecurityStrategy.map(value => value.unwrap))(
        _.smbSecurityStrategy
      )
      .optionallyWith(fileSharesVisible.map(value => value: java.lang.Boolean))(
        _.fileSharesVisible
      )
      .optionallyWith(smbLocalGroups.map(value => value.buildAwsValue()))(
        _.smbLocalGroups
      )
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeSmbSettingsResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeSmbSettingsResponse
      .wrap(buildAwsValue())
}
object DescribeSmbSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeSmbSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DescribeSmbSettingsResponse =
      zio.aws.storagegateway.model.DescribeSmbSettingsResponse(
        gatewayARN.map(value => value),
        domainName.map(value => value),
        activeDirectoryStatus.map(value => value),
        smbGuestPasswordSet.map(value => value),
        smbSecurityStrategy.map(value => value),
        fileSharesVisible.map(value => value),
        smbLocalGroups.map(value => value.asEditable)
      )
    def gatewayARN: Option[GatewayARN]
    def domainName: Option[DomainName]
    def activeDirectoryStatus
        : Option[zio.aws.storagegateway.model.ActiveDirectoryStatus]
    def smbGuestPasswordSet: Option[Boolean]
    def smbSecurityStrategy
        : Option[zio.aws.storagegateway.model.SMBSecurityStrategy]
    def fileSharesVisible: Option[Boolean]
    def smbLocalGroups
        : Option[zio.aws.storagegateway.model.SMBLocalGroups.ReadOnly]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getActiveDirectoryStatus: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.ActiveDirectoryStatus
    ] =
      AwsError.unwrapOptionField("activeDirectoryStatus", activeDirectoryStatus)
    def getSmbGuestPasswordSet: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("smbGuestPasswordSet", smbGuestPasswordSet)
    def getSmbSecurityStrategy
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.SMBSecurityStrategy] =
      AwsError.unwrapOptionField("smbSecurityStrategy", smbSecurityStrategy)
    def getFileSharesVisible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("fileSharesVisible", fileSharesVisible)
    def getSmbLocalGroups: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.SMBLocalGroups.ReadOnly
    ] = AwsError.unwrapOptionField("smbLocalGroups", smbLocalGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeSmbSettingsResponse
  ) extends zio.aws.storagegateway.model.DescribeSmbSettingsResponse.ReadOnly {
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val domainName: Option[DomainName] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.storagegateway.model.primitives.DomainName(value))
    override val activeDirectoryStatus
        : Option[zio.aws.storagegateway.model.ActiveDirectoryStatus] = scala
      .Option(impl.activeDirectoryStatus())
      .map(value =>
        zio.aws.storagegateway.model.ActiveDirectoryStatus.wrap(value)
      )
    override val smbGuestPasswordSet: Option[Boolean] =
      scala.Option(impl.smbGuestPasswordSet()).map(value => value: Boolean)
    override val smbSecurityStrategy
        : Option[zio.aws.storagegateway.model.SMBSecurityStrategy] = scala
      .Option(impl.smbSecurityStrategy())
      .map(value =>
        zio.aws.storagegateway.model.SMBSecurityStrategy.wrap(value)
      )
    override val fileSharesVisible: Option[Boolean] =
      scala.Option(impl.fileSharesVisible()).map(value => value: Boolean)
    override val smbLocalGroups
        : Option[zio.aws.storagegateway.model.SMBLocalGroups.ReadOnly] = scala
      .Option(impl.smbLocalGroups())
      .map(value => zio.aws.storagegateway.model.SMBLocalGroups.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeSmbSettingsResponse
  ): zio.aws.storagegateway.model.DescribeSmbSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
