package zio.aws.storagegateway.model
import java.lang.Integer
import zio.aws.storagegateway.model.primitives.CacheStaleTimeoutInSeconds
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CacheAttributes(
    cacheStaleTimeoutInSeconds: Option[CacheStaleTimeoutInSeconds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CacheAttributes = {
    import CacheAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CacheAttributes
      .builder()
      .optionallyWith(
        cacheStaleTimeoutInSeconds.map(value =>
          CacheStaleTimeoutInSeconds.unwrap(value): Integer
        )
      )(_.cacheStaleTimeoutInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.CacheAttributes.ReadOnly =
    zio.aws.storagegateway.model.CacheAttributes.wrap(buildAwsValue())
}
object CacheAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CacheAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.CacheAttributes =
      zio.aws.storagegateway.model
        .CacheAttributes(cacheStaleTimeoutInSeconds.map(value => value))
    def cacheStaleTimeoutInSeconds: Option[CacheStaleTimeoutInSeconds]
    def getCacheStaleTimeoutInSeconds
        : ZIO[Any, AwsError, CacheStaleTimeoutInSeconds] =
      AwsError.unwrapOptionField(
        "cacheStaleTimeoutInSeconds",
        cacheStaleTimeoutInSeconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CacheAttributes
  ) extends zio.aws.storagegateway.model.CacheAttributes.ReadOnly {
    override val cacheStaleTimeoutInSeconds
        : Option[CacheStaleTimeoutInSeconds] = scala
      .Option(impl.cacheStaleTimeoutInSeconds())
      .map(value =>
        zio.aws.storagegateway.model.primitives
          .CacheStaleTimeoutInSeconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CacheAttributes
  ): zio.aws.storagegateway.model.CacheAttributes.ReadOnly = new Wrapper(impl)
}
