package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResetCacheResponse(gatewayARN: Option[GatewayARN] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ResetCacheResponse = {
    import ResetCacheResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ResetCacheResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.ResetCacheResponse.ReadOnly =
    zio.aws.storagegateway.model.ResetCacheResponse.wrap(buildAwsValue())
}
object ResetCacheResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ResetCacheResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ResetCacheResponse =
      zio.aws.storagegateway.model
        .ResetCacheResponse(gatewayARN.map(value => value))
    def gatewayARN: Option[GatewayARN]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ResetCacheResponse
  ) extends zio.aws.storagegateway.model.ResetCacheResponse.ReadOnly {
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ResetCacheResponse
  ): zio.aws.storagegateway.model.ResetCacheResponse.ReadOnly = new Wrapper(
    impl
  )
}
