package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListFileSharesResponse(
    marker: Option[Marker] = None,
    nextMarker: Option[Marker] = None,
    fileShareInfoList: Option[
      Iterable[zio.aws.storagegateway.model.FileShareInfo]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse = {
    import ListFileSharesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse
      .builder()
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        fileShareInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileShareInfoList)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.ListFileSharesResponse.ReadOnly =
    zio.aws.storagegateway.model.ListFileSharesResponse.wrap(buildAwsValue())
}
object ListFileSharesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ListFileSharesResponse =
      zio.aws.storagegateway.model.ListFileSharesResponse(
        marker.map(value => value),
        nextMarker.map(value => value),
        fileShareInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[Marker]
    def nextMarker: Option[Marker]
    def fileShareInfoList
        : Option[List[zio.aws.storagegateway.model.FileShareInfo.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getFileShareInfoList: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.FileShareInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("fileShareInfoList", fileShareInfoList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse
  ) extends zio.aws.storagegateway.model.ListFileSharesResponse.ReadOnly {
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
    override val nextMarker: Option[Marker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
    override val fileShareInfoList
        : Option[List[zio.aws.storagegateway.model.FileShareInfo.ReadOnly]] =
      scala
        .Option(impl.fileShareInfoList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.FileShareInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse
  ): zio.aws.storagegateway.model.ListFileSharesResponse.ReadOnly = new Wrapper(
    impl
  )
}
