package zio.aws.storagegateway.model
import java.lang.Integer
import zio.aws.storagegateway.model.primitives.{
  PositiveIntObject,
  Marker,
  TapeARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeTapeArchivesRequest(
    tapeARNs: Option[Iterable[TapeARN]] = None,
    marker: Option[Marker] = None,
    limit: Option[PositiveIntObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesRequest = {
    import DescribeTapeArchivesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesRequest
      .builder()
      .optionallyWith(
        tapeARNs.map(value =>
          value.map { item =>
            TapeARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tapeARNs)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        limit.map(value => PositiveIntObject.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeTapeArchivesRequest.ReadOnly =
    zio.aws.storagegateway.model.DescribeTapeArchivesRequest
      .wrap(buildAwsValue())
}
object DescribeTapeArchivesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DescribeTapeArchivesRequest =
      zio.aws.storagegateway.model.DescribeTapeArchivesRequest(
        tapeARNs.map(value => value),
        marker.map(value => value),
        limit.map(value => value)
      )
    def tapeARNs: Option[List[TapeARN]]
    def marker: Option[Marker]
    def limit: Option[PositiveIntObject]
    def getTapeARNs: ZIO[Any, AwsError, List[TapeARN]] =
      AwsError.unwrapOptionField("tapeARNs", tapeARNs)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getLimit: ZIO[Any, AwsError, PositiveIntObject] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesRequest
  ) extends zio.aws.storagegateway.model.DescribeTapeArchivesRequest.ReadOnly {
    override val tapeARNs: Option[List[TapeARN]] = scala
      .Option(impl.tapeARNs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.primitives.TapeARN(item)
        }.toList
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
    override val limit: Option[PositiveIntObject] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.storagegateway.model.primitives.PositiveIntObject(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesRequest
  ): zio.aws.storagegateway.model.DescribeTapeArchivesRequest.ReadOnly =
    new Wrapper(impl)
}
