package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{TargetARN, VolumeARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AttachVolumeResponse(
    volumeARN: Option[VolumeARN] = None,
    targetARN: Option[TargetARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.AttachVolumeResponse = {
    import AttachVolumeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.AttachVolumeResponse
      .builder()
      .optionallyWith(
        volumeARN.map(value => VolumeARN.unwrap(value): java.lang.String)
      )(_.volumeARN)
      .optionallyWith(
        targetARN.map(value => TargetARN.unwrap(value): java.lang.String)
      )(_.targetARN)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.AttachVolumeResponse.ReadOnly =
    zio.aws.storagegateway.model.AttachVolumeResponse.wrap(buildAwsValue())
}
object AttachVolumeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.AttachVolumeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.AttachVolumeResponse =
      zio.aws.storagegateway.model.AttachVolumeResponse(
        volumeARN.map(value => value),
        targetARN.map(value => value)
      )
    def volumeARN: Option[VolumeARN]
    def targetARN: Option[TargetARN]
    def getVolumeARN: ZIO[Any, AwsError, VolumeARN] =
      AwsError.unwrapOptionField("volumeARN", volumeARN)
    def getTargetARN: ZIO[Any, AwsError, TargetARN] =
      AwsError.unwrapOptionField("targetARN", targetARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.AttachVolumeResponse
  ) extends zio.aws.storagegateway.model.AttachVolumeResponse.ReadOnly {
    override val volumeARN: Option[VolumeARN] = scala
      .Option(impl.volumeARN())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeARN(value))
    override val targetARN: Option[TargetARN] = scala
      .Option(impl.targetARN())
      .map(value => zio.aws.storagegateway.model.primitives.TargetARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.AttachVolumeResponse
  ): zio.aws.storagegateway.model.AttachVolumeResponse.ReadOnly = new Wrapper(
    impl
  )
}
