package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{Marker, GatewayARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeTapeRecoveryPointsResponse(
    gatewayARN: Option[GatewayARN] = None,
    tapeRecoveryPointInfos: Option[
      Iterable[zio.aws.storagegateway.model.TapeRecoveryPointInfo]
    ] = None,
    marker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsResponse = {
    import DescribeTapeRecoveryPointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        tapeRecoveryPointInfos.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tapeRecoveryPointInfos)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeTapeRecoveryPointsResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeTapeRecoveryPointsResponse
      .wrap(buildAwsValue())
}
object DescribeTapeRecoveryPointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeTapeRecoveryPointsResponse =
      zio.aws.storagegateway.model.DescribeTapeRecoveryPointsResponse(
        gatewayARN.map(value => value),
        tapeRecoveryPointInfos.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def gatewayARN: Option[GatewayARN]
    def tapeRecoveryPointInfos: Option[
      List[zio.aws.storagegateway.model.TapeRecoveryPointInfo.ReadOnly]
    ]
    def marker: Option[Marker]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getTapeRecoveryPointInfos: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.TapeRecoveryPointInfo.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "tapeRecoveryPointInfos",
      tapeRecoveryPointInfos
    )
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsResponse
  ) extends zio.aws.storagegateway.model.DescribeTapeRecoveryPointsResponse.ReadOnly {
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val tapeRecoveryPointInfos: Option[
      List[zio.aws.storagegateway.model.TapeRecoveryPointInfo.ReadOnly]
    ] = scala
      .Option(impl.tapeRecoveryPointInfos())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.TapeRecoveryPointInfo.wrap(item)
        }.toList
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsResponse
  ): zio.aws.storagegateway.model.DescribeTapeRecoveryPointsResponse.ReadOnly =
    new Wrapper(impl)
}
