package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{SnapshotDescription, VolumeARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateSnapshotRequest(
    volumeARN: VolumeARN,
    snapshotDescription: SnapshotDescription,
    tags: Option[Iterable[zio.aws.storagegateway.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CreateSnapshotRequest = {
    import CreateSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CreateSnapshotRequest
      .builder()
      .volumeARN(VolumeARN.unwrap(volumeARN): java.lang.String)
      .snapshotDescription(
        SnapshotDescription.unwrap(snapshotDescription): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.CreateSnapshotRequest.ReadOnly =
    zio.aws.storagegateway.model.CreateSnapshotRequest.wrap(buildAwsValue())
}
object CreateSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CreateSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.CreateSnapshotRequest =
      zio.aws.storagegateway.model.CreateSnapshotRequest(
        volumeARN,
        snapshotDescription,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def volumeARN: VolumeARN
    def snapshotDescription: SnapshotDescription
    def tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]]
    def getVolumeARN: ZIO[Any, Nothing, VolumeARN] = ZIO.succeed(volumeARN)
    def getSnapshotDescription: ZIO[Any, Nothing, SnapshotDescription] =
      ZIO.succeed(snapshotDescription)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateSnapshotRequest
  ) extends zio.aws.storagegateway.model.CreateSnapshotRequest.ReadOnly {
    override val volumeARN: VolumeARN =
      zio.aws.storagegateway.model.primitives.VolumeARN(impl.volumeARN())
    override val snapshotDescription: SnapshotDescription =
      zio.aws.storagegateway.model.primitives
        .SnapshotDescription(impl.snapshotDescription())
    override val tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateSnapshotRequest
  ): zio.aws.storagegateway.model.CreateSnapshotRequest.ReadOnly = new Wrapper(
    impl
  )
}
