package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  GatewayId,
  VolumeARN,
  GatewayARN,
  VolumeId,
  VolumeAttachmentStatus,
  VolumeType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class VolumeInfo(
    volumeARN: Option[VolumeARN] = None,
    volumeId: Option[VolumeId] = None,
    gatewayARN: Option[GatewayARN] = None,
    gatewayId: Option[GatewayId] = None,
    volumeType: Option[VolumeType] = None,
    volumeSizeInBytes: Option[Long] = None,
    volumeAttachmentStatus: Option[VolumeAttachmentStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.VolumeInfo = {
    import VolumeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.VolumeInfo
      .builder()
      .optionallyWith(
        volumeARN.map(value => VolumeARN.unwrap(value): java.lang.String)
      )(_.volumeARN)
      .optionallyWith(
        volumeId.map(value => VolumeId.unwrap(value): java.lang.String)
      )(_.volumeId)
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        gatewayId.map(value => GatewayId.unwrap(value): java.lang.String)
      )(_.gatewayId)
      .optionallyWith(
        volumeType.map(value => VolumeType.unwrap(value): java.lang.String)
      )(_.volumeType)
      .optionallyWith(volumeSizeInBytes.map(value => value: java.lang.Long))(
        _.volumeSizeInBytes
      )
      .optionallyWith(
        volumeAttachmentStatus.map(value =>
          VolumeAttachmentStatus.unwrap(value): java.lang.String
        )
      )(_.volumeAttachmentStatus)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.VolumeInfo.ReadOnly =
    zio.aws.storagegateway.model.VolumeInfo.wrap(buildAwsValue())
}
object VolumeInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.VolumeInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.VolumeInfo =
      zio.aws.storagegateway.model.VolumeInfo(
        volumeARN.map(value => value),
        volumeId.map(value => value),
        gatewayARN.map(value => value),
        gatewayId.map(value => value),
        volumeType.map(value => value),
        volumeSizeInBytes.map(value => value),
        volumeAttachmentStatus.map(value => value)
      )
    def volumeARN: Option[VolumeARN]
    def volumeId: Option[VolumeId]
    def gatewayARN: Option[GatewayARN]
    def gatewayId: Option[GatewayId]
    def volumeType: Option[VolumeType]
    def volumeSizeInBytes: Option[Long]
    def volumeAttachmentStatus: Option[VolumeAttachmentStatus]
    def getVolumeARN: ZIO[Any, AwsError, VolumeARN] =
      AwsError.unwrapOptionField("volumeARN", volumeARN)
    def getVolumeId: ZIO[Any, AwsError, VolumeId] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getGatewayId: ZIO[Any, AwsError, GatewayId] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getVolumeType: ZIO[Any, AwsError, VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getVolumeSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("volumeSizeInBytes", volumeSizeInBytes)
    def getVolumeAttachmentStatus: ZIO[Any, AwsError, VolumeAttachmentStatus] =
      AwsError.unwrapOptionField(
        "volumeAttachmentStatus",
        volumeAttachmentStatus
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.VolumeInfo
  ) extends zio.aws.storagegateway.model.VolumeInfo.ReadOnly {
    override val volumeARN: Option[VolumeARN] = scala
      .Option(impl.volumeARN())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeARN(value))
    override val volumeId: Option[VolumeId] = scala
      .Option(impl.volumeId())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeId(value))
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val gatewayId: Option[GatewayId] = scala
      .Option(impl.gatewayId())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayId(value))
    override val volumeType: Option[VolumeType] = scala
      .Option(impl.volumeType())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeType(value))
    override val volumeSizeInBytes: Option[Long] =
      scala.Option(impl.volumeSizeInBytes()).map(value => value: Long)
    override val volumeAttachmentStatus: Option[VolumeAttachmentStatus] = scala
      .Option(impl.volumeAttachmentStatus())
      .map(value =>
        zio.aws.storagegateway.model.primitives.VolumeAttachmentStatus(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.VolumeInfo
  ): zio.aws.storagegateway.model.VolumeInfo.ReadOnly = new Wrapper(impl)
}
