package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTapePoolsResponse(
    poolInfos: Option[Iterable[zio.aws.storagegateway.model.PoolInfo]] = None,
    marker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListTapePoolsResponse = {
    import ListTapePoolsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListTapePoolsResponse
      .builder()
      .optionallyWith(
        poolInfos.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.poolInfos)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.ListTapePoolsResponse.ReadOnly =
    zio.aws.storagegateway.model.ListTapePoolsResponse.wrap(buildAwsValue())
}
object ListTapePoolsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListTapePoolsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ListTapePoolsResponse =
      zio.aws.storagegateway.model.ListTapePoolsResponse(
        poolInfos.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def poolInfos: Option[List[zio.aws.storagegateway.model.PoolInfo.ReadOnly]]
    def marker: Option[Marker]
    def getPoolInfos: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.PoolInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("poolInfos", poolInfos)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListTapePoolsResponse
  ) extends zio.aws.storagegateway.model.ListTapePoolsResponse.ReadOnly {
    override val poolInfos
        : Option[List[zio.aws.storagegateway.model.PoolInfo.ReadOnly]] = scala
      .Option(impl.poolInfos())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.PoolInfo.wrap(item)
        }.toList
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListTapePoolsResponse
  ): zio.aws.storagegateway.model.ListTapePoolsResponse.ReadOnly = new Wrapper(
    impl
  )
}
