package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  PoolId,
  Time,
  TapeSize,
  KMSKey,
  TapeARN,
  TapeBarcode,
  TapeArchiveStatus,
  GatewayARN,
  TapeUsage
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class TapeArchive(
    tapeARN: Option[TapeARN] = None,
    tapeBarcode: Option[TapeBarcode] = None,
    tapeCreatedDate: Option[Time] = None,
    tapeSizeInBytes: Option[TapeSize] = None,
    completionTime: Option[Time] = None,
    retrievedTo: Option[GatewayARN] = None,
    tapeStatus: Option[TapeArchiveStatus] = None,
    tapeUsedInBytes: Option[TapeUsage] = None,
    kmsKey: Option[KMSKey] = None,
    poolId: Option[PoolId] = None,
    worm: Option[Boolean] = None,
    retentionStartDate: Option[Time] = None,
    poolEntryDate: Option[Time] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.TapeArchive = {
    import TapeArchive.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.TapeArchive
      .builder()
      .optionallyWith(
        tapeARN.map(value => TapeARN.unwrap(value): java.lang.String)
      )(_.tapeARN)
      .optionallyWith(
        tapeBarcode.map(value => TapeBarcode.unwrap(value): java.lang.String)
      )(_.tapeBarcode)
      .optionallyWith(
        tapeCreatedDate.map(value => Time.unwrap(value): Instant)
      )(_.tapeCreatedDate)
      .optionallyWith(
        tapeSizeInBytes.map(value => TapeSize.unwrap(value): java.lang.Long)
      )(_.tapeSizeInBytes)
      .optionallyWith(completionTime.map(value => Time.unwrap(value): Instant))(
        _.completionTime
      )
      .optionallyWith(
        retrievedTo.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.retrievedTo)
      .optionallyWith(
        tapeStatus.map(value =>
          TapeArchiveStatus.unwrap(value): java.lang.String
        )
      )(_.tapeStatus)
      .optionallyWith(
        tapeUsedInBytes.map(value => TapeUsage.unwrap(value): java.lang.Long)
      )(_.tapeUsedInBytes)
      .optionallyWith(
        kmsKey.map(value => KMSKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(
        poolId.map(value => PoolId.unwrap(value): java.lang.String)
      )(_.poolId)
      .optionallyWith(worm.map(value => value: java.lang.Boolean))(_.worm)
      .optionallyWith(
        retentionStartDate.map(value => Time.unwrap(value): Instant)
      )(_.retentionStartDate)
      .optionallyWith(poolEntryDate.map(value => Time.unwrap(value): Instant))(
        _.poolEntryDate
      )
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.TapeArchive.ReadOnly =
    zio.aws.storagegateway.model.TapeArchive.wrap(buildAwsValue())
}
object TapeArchive {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.TapeArchive
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.TapeArchive =
      zio.aws.storagegateway.model.TapeArchive(
        tapeARN.map(value => value),
        tapeBarcode.map(value => value),
        tapeCreatedDate.map(value => value),
        tapeSizeInBytes.map(value => value),
        completionTime.map(value => value),
        retrievedTo.map(value => value),
        tapeStatus.map(value => value),
        tapeUsedInBytes.map(value => value),
        kmsKey.map(value => value),
        poolId.map(value => value),
        worm.map(value => value),
        retentionStartDate.map(value => value),
        poolEntryDate.map(value => value)
      )
    def tapeARN: Option[TapeARN]
    def tapeBarcode: Option[TapeBarcode]
    def tapeCreatedDate: Option[Time]
    def tapeSizeInBytes: Option[TapeSize]
    def completionTime: Option[Time]
    def retrievedTo: Option[GatewayARN]
    def tapeStatus: Option[TapeArchiveStatus]
    def tapeUsedInBytes: Option[TapeUsage]
    def kmsKey: Option[KMSKey]
    def poolId: Option[PoolId]
    def worm: Option[Boolean]
    def retentionStartDate: Option[Time]
    def poolEntryDate: Option[Time]
    def getTapeARN: ZIO[Any, AwsError, TapeARN] =
      AwsError.unwrapOptionField("tapeARN", tapeARN)
    def getTapeBarcode: ZIO[Any, AwsError, TapeBarcode] =
      AwsError.unwrapOptionField("tapeBarcode", tapeBarcode)
    def getTapeCreatedDate: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("tapeCreatedDate", tapeCreatedDate)
    def getTapeSizeInBytes: ZIO[Any, AwsError, TapeSize] =
      AwsError.unwrapOptionField("tapeSizeInBytes", tapeSizeInBytes)
    def getCompletionTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getRetrievedTo: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("retrievedTo", retrievedTo)
    def getTapeStatus: ZIO[Any, AwsError, TapeArchiveStatus] =
      AwsError.unwrapOptionField("tapeStatus", tapeStatus)
    def getTapeUsedInBytes: ZIO[Any, AwsError, TapeUsage] =
      AwsError.unwrapOptionField("tapeUsedInBytes", tapeUsedInBytes)
    def getKmsKey: ZIO[Any, AwsError, KMSKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getPoolId: ZIO[Any, AwsError, PoolId] =
      AwsError.unwrapOptionField("poolId", poolId)
    def getWorm: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("worm", worm)
    def getRetentionStartDate: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("retentionStartDate", retentionStartDate)
    def getPoolEntryDate: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("poolEntryDate", poolEntryDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.TapeArchive
  ) extends zio.aws.storagegateway.model.TapeArchive.ReadOnly {
    override val tapeARN: Option[TapeARN] = scala
      .Option(impl.tapeARN())
      .map(value => zio.aws.storagegateway.model.primitives.TapeARN(value))
    override val tapeBarcode: Option[TapeBarcode] = scala
      .Option(impl.tapeBarcode())
      .map(value => zio.aws.storagegateway.model.primitives.TapeBarcode(value))
    override val tapeCreatedDate: Option[Time] = scala
      .Option(impl.tapeCreatedDate())
      .map(value => zio.aws.storagegateway.model.primitives.Time(value))
    override val tapeSizeInBytes: Option[TapeSize] = scala
      .Option(impl.tapeSizeInBytes())
      .map(value => zio.aws.storagegateway.model.primitives.TapeSize(value))
    override val completionTime: Option[Time] = scala
      .Option(impl.completionTime())
      .map(value => zio.aws.storagegateway.model.primitives.Time(value))
    override val retrievedTo: Option[GatewayARN] = scala
      .Option(impl.retrievedTo())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val tapeStatus: Option[TapeArchiveStatus] = scala
      .Option(impl.tapeStatus())
      .map(value =>
        zio.aws.storagegateway.model.primitives.TapeArchiveStatus(value)
      )
    override val tapeUsedInBytes: Option[TapeUsage] = scala
      .Option(impl.tapeUsedInBytes())
      .map(value => zio.aws.storagegateway.model.primitives.TapeUsage(value))
    override val kmsKey: Option[KMSKey] = scala
      .Option(impl.kmsKey())
      .map(value => zio.aws.storagegateway.model.primitives.KMSKey(value))
    override val poolId: Option[PoolId] = scala
      .Option(impl.poolId())
      .map(value => zio.aws.storagegateway.model.primitives.PoolId(value))
    override val worm: Option[Boolean] =
      scala.Option(impl.worm()).map(value => value: Boolean)
    override val retentionStartDate: Option[Time] = scala
      .Option(impl.retentionStartDate())
      .map(value => zio.aws.storagegateway.model.primitives.Time(value))
    override val poolEntryDate: Option[Time] = scala
      .Option(impl.poolEntryDate())
      .map(value => zio.aws.storagegateway.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.TapeArchive
  ): zio.aws.storagegateway.model.TapeArchive.ReadOnly = new Wrapper(impl)
}
