package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.FileShareARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeSmbFileSharesRequest(
    fileShareARNList: Iterable[FileShareARN]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeSmbFileSharesRequest = {
    import DescribeSmbFileSharesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeSmbFileSharesRequest
      .builder()
      .fileShareARNList(fileShareARNList.map { item =>
        FileShareARN.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeSmbFileSharesRequest.ReadOnly =
    zio.aws.storagegateway.model.DescribeSmbFileSharesRequest
      .wrap(buildAwsValue())
}
object DescribeSmbFileSharesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeSmbFileSharesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DescribeSmbFileSharesRequest =
      zio.aws.storagegateway.model
        .DescribeSmbFileSharesRequest(fileShareARNList)
    def fileShareARNList: List[FileShareARN]
    def getFileShareARNList: ZIO[Any, Nothing, List[FileShareARN]] =
      ZIO.succeed(fileShareARNList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeSmbFileSharesRequest
  ) extends zio.aws.storagegateway.model.DescribeSmbFileSharesRequest.ReadOnly {
    override val fileShareARNList: List[FileShareARN] = impl
      .fileShareARNList()
      .asScala
      .map { item =>
        zio.aws.storagegateway.model.primitives.FileShareARN(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeSmbFileSharesRequest
  ): zio.aws.storagegateway.model.DescribeSmbFileSharesRequest.ReadOnly =
    new Wrapper(impl)
}
