package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeMaintenanceStartTimeRequest(gatewayARN: GatewayARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeMaintenanceStartTimeRequest = {
    import DescribeMaintenanceStartTimeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeMaintenanceStartTimeRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeMaintenanceStartTimeRequest.ReadOnly =
    zio.aws.storagegateway.model.DescribeMaintenanceStartTimeRequest
      .wrap(buildAwsValue())
}
object DescribeMaintenanceStartTimeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeMaintenanceStartTimeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeMaintenanceStartTimeRequest =
      zio.aws.storagegateway.model
        .DescribeMaintenanceStartTimeRequest(gatewayARN)
    def gatewayARN: GatewayARN
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeMaintenanceStartTimeRequest
  ) extends zio.aws.storagegateway.model.DescribeMaintenanceStartTimeRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeMaintenanceStartTimeRequest
  ): zio.aws.storagegateway.model.DescribeMaintenanceStartTimeRequest.ReadOnly =
    new Wrapper(impl)
}
