package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{PoolId, TapeARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AssignTapePoolRequest(
    tapeARN: TapeARN,
    poolId: PoolId,
    bypassGovernanceRetention: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.AssignTapePoolRequest = {
    import AssignTapePoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.AssignTapePoolRequest
      .builder()
      .tapeARN(TapeARN.unwrap(tapeARN): java.lang.String)
      .poolId(PoolId.unwrap(poolId): java.lang.String)
      .optionallyWith(
        bypassGovernanceRetention.map(value => value: java.lang.Boolean)
      )(_.bypassGovernanceRetention)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.AssignTapePoolRequest.ReadOnly =
    zio.aws.storagegateway.model.AssignTapePoolRequest.wrap(buildAwsValue())
}
object AssignTapePoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.AssignTapePoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.AssignTapePoolRequest =
      zio.aws.storagegateway.model.AssignTapePoolRequest(
        tapeARN,
        poolId,
        bypassGovernanceRetention.map(value => value)
      )
    def tapeARN: TapeARN
    def poolId: PoolId
    def bypassGovernanceRetention: Option[Boolean]
    def getTapeARN: ZIO[Any, Nothing, TapeARN] = ZIO.succeed(tapeARN)
    def getPoolId: ZIO[Any, Nothing, PoolId] = ZIO.succeed(poolId)
    def getBypassGovernanceRetention: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("bypassGovernanceRetention", bypassGovernanceRetention)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.AssignTapePoolRequest
  ) extends zio.aws.storagegateway.model.AssignTapePoolRequest.ReadOnly {
    override val tapeARN: TapeARN =
      zio.aws.storagegateway.model.primitives.TapeARN(impl.tapeARN())
    override val poolId: PoolId =
      zio.aws.storagegateway.model.primitives.PoolId(impl.poolId())
    override val bypassGovernanceRetention: Option[Boolean] = scala
      .Option(impl.bypassGovernanceRetention())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.AssignTapePoolRequest
  ): zio.aws.storagegateway.model.AssignTapePoolRequest.ReadOnly = new Wrapper(
    impl
  )
}
