package zio.aws.storagegateway.model
import scala.jdk.CollectionConverters.*
sealed trait TapeStorageClass {
  def unwrap
      : software.amazon.awssdk.services.storagegateway.model.TapeStorageClass
}
object TapeStorageClass {
  def wrap(
      value: software.amazon.awssdk.services.storagegateway.model.TapeStorageClass
  ): zio.aws.storagegateway.model.TapeStorageClass = value match {
    case software.amazon.awssdk.services.storagegateway.model.TapeStorageClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.storagegateway.model.TapeStorageClass.DEEP_ARCHIVE =>
      val r = DEEP_ARCHIVE
      r
    case software.amazon.awssdk.services.storagegateway.model.TapeStorageClass.GLACIER =>
      val r = GLACIER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.storagegateway.model.TapeStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.TapeStorageClass =
      software.amazon.awssdk.services.storagegateway.model.TapeStorageClass.UNKNOWN_TO_SDK_VERSION
  }
  case object DEEP_ARCHIVE
      extends zio.aws.storagegateway.model.TapeStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.TapeStorageClass =
      software.amazon.awssdk.services.storagegateway.model.TapeStorageClass.DEEP_ARCHIVE
  }
  case object GLACIER extends zio.aws.storagegateway.model.TapeStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.TapeStorageClass =
      software.amazon.awssdk.services.storagegateway.model.TapeStorageClass.GLACIER
  }
}
