package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{PermissionId, PermissionMode}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NFSFileShareDefaults(
    fileMode: Option[PermissionMode] = None,
    directoryMode: Option[PermissionMode] = None,
    groupId: Option[PermissionId] = None,
    ownerId: Option[PermissionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.NFSFileShareDefaults = {
    import NFSFileShareDefaults.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.NFSFileShareDefaults
      .builder()
      .optionallyWith(
        fileMode.map(value => PermissionMode.unwrap(value): java.lang.String)
      )(_.fileMode)
      .optionallyWith(
        directoryMode.map(value =>
          PermissionMode.unwrap(value): java.lang.String
        )
      )(_.directoryMode)
      .optionallyWith(
        groupId.map(value => PermissionId.unwrap(value): java.lang.Long)
      )(_.groupId)
      .optionallyWith(
        ownerId.map(value => PermissionId.unwrap(value): java.lang.Long)
      )(_.ownerId)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.NFSFileShareDefaults.ReadOnly =
    zio.aws.storagegateway.model.NFSFileShareDefaults.wrap(buildAwsValue())
}
object NFSFileShareDefaults {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.NFSFileShareDefaults
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.NFSFileShareDefaults =
      zio.aws.storagegateway.model.NFSFileShareDefaults(
        fileMode.map(value => value),
        directoryMode.map(value => value),
        groupId.map(value => value),
        ownerId.map(value => value)
      )
    def fileMode: Option[PermissionMode]
    def directoryMode: Option[PermissionMode]
    def groupId: Option[PermissionId]
    def ownerId: Option[PermissionId]
    def getFileMode: ZIO[Any, AwsError, PermissionMode] =
      AwsError.unwrapOptionField("fileMode", fileMode)
    def getDirectoryMode: ZIO[Any, AwsError, PermissionMode] =
      AwsError.unwrapOptionField("directoryMode", directoryMode)
    def getGroupId: ZIO[Any, AwsError, PermissionId] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getOwnerId: ZIO[Any, AwsError, PermissionId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.NFSFileShareDefaults
  ) extends zio.aws.storagegateway.model.NFSFileShareDefaults.ReadOnly {
    override val fileMode: Option[PermissionMode] = scala
      .Option(impl.fileMode())
      .map(value =>
        zio.aws.storagegateway.model.primitives.PermissionMode(value)
      )
    override val directoryMode: Option[PermissionMode] = scala
      .Option(impl.directoryMode())
      .map(value =>
        zio.aws.storagegateway.model.primitives.PermissionMode(value)
      )
    override val groupId: Option[PermissionId] = scala
      .Option(impl.groupId())
      .map(value => zio.aws.storagegateway.model.primitives.PermissionId(value))
    override val ownerId: Option[PermissionId] = scala
      .Option(impl.ownerId())
      .map(value => zio.aws.storagegateway.model.primitives.PermissionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.NFSFileShareDefaults
  ): zio.aws.storagegateway.model.NFSFileShareDefaults.ReadOnly = new Wrapper(
    impl
  )
}
