package zio.aws.storagegateway.model
import java.lang.Integer
import zio.aws.storagegateway.model.primitives.{
  PositiveIntObject,
  Marker,
  ResourceARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(
    resourceARN: ResourceARN,
    marker: Option[Marker] = None,
    limit: Option[PositiveIntObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(ResourceARN.unwrap(resourceARN): java.lang.String)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        limit.map(value => PositiveIntObject.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.storagegateway.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ListTagsForResourceRequest =
      zio.aws.storagegateway.model.ListTagsForResourceRequest(
        resourceARN,
        marker.map(value => value),
        limit.map(value => value)
      )
    def resourceARN: ResourceARN
    def marker: Option[Marker]
    def limit: Option[PositiveIntObject]
    def getResourceARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARN)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getLimit: ZIO[Any, AwsError, PositiveIntObject] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceRequest
  ) extends zio.aws.storagegateway.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceARN: ResourceARN =
      zio.aws.storagegateway.model.primitives.ResourceARN(impl.resourceARN())
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
    override val limit: Option[PositiveIntObject] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.storagegateway.model.primitives.PositiveIntObject(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceRequest
  ): zio.aws.storagegateway.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
