package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.FileShareARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeNfsFileSharesRequest(
    fileShareARNList: Iterable[FileShareARN]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeNfsFileSharesRequest = {
    import DescribeNfsFileSharesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeNfsFileSharesRequest
      .builder()
      .fileShareARNList(fileShareARNList.map { item =>
        FileShareARN.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeNfsFileSharesRequest.ReadOnly =
    zio.aws.storagegateway.model.DescribeNfsFileSharesRequest
      .wrap(buildAwsValue())
}
object DescribeNfsFileSharesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeNfsFileSharesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DescribeNfsFileSharesRequest =
      zio.aws.storagegateway.model
        .DescribeNfsFileSharesRequest(fileShareARNList)
    def fileShareARNList: List[FileShareARN]
    def getFileShareARNList: ZIO[Any, Nothing, List[FileShareARN]] =
      ZIO.succeed(fileShareARNList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeNfsFileSharesRequest
  ) extends zio.aws.storagegateway.model.DescribeNfsFileSharesRequest.ReadOnly {
    override val fileShareARNList: List[FileShareARN] = impl
      .fileShareARNList()
      .asScala
      .map { item =>
        zio.aws.storagegateway.model.primitives.FileShareARN(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeNfsFileSharesRequest
  ): zio.aws.storagegateway.model.DescribeNfsFileSharesRequest.ReadOnly =
    new Wrapper(impl)
}
