package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  AuditDestinationARN,
  DomainUserPassword,
  DomainUserName,
  FileSystemAssociationARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateFileSystemAssociationRequest(
    fileSystemAssociationARN: FileSystemAssociationARN,
    userName: Option[DomainUserName] = None,
    password: Option[DomainUserPassword] = None,
    auditDestinationARN: Option[AuditDestinationARN] = None,
    cacheAttributes: Option[zio.aws.storagegateway.model.CacheAttributes] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationRequest = {
    import UpdateFileSystemAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationRequest
      .builder()
      .fileSystemAssociationARN(
        FileSystemAssociationARN.unwrap(
          fileSystemAssociationARN
        ): java.lang.String
      )
      .optionallyWith(
        userName.map(value => DomainUserName.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        password.map(value =>
          DomainUserPassword.unwrap(value): java.lang.String
        )
      )(_.password)
      .optionallyWith(
        auditDestinationARN.map(value =>
          AuditDestinationARN.unwrap(value): java.lang.String
        )
      )(_.auditDestinationARN)
      .optionallyWith(cacheAttributes.map(value => value.buildAwsValue()))(
        _.cacheAttributes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateFileSystemAssociationRequest.ReadOnly =
    zio.aws.storagegateway.model.UpdateFileSystemAssociationRequest
      .wrap(buildAwsValue())
}
object UpdateFileSystemAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.UpdateFileSystemAssociationRequest =
      zio.aws.storagegateway.model.UpdateFileSystemAssociationRequest(
        fileSystemAssociationARN,
        userName.map(value => value),
        password.map(value => value),
        auditDestinationARN.map(value => value),
        cacheAttributes.map(value => value.asEditable)
      )
    def fileSystemAssociationARN: FileSystemAssociationARN
    def userName: Option[DomainUserName]
    def password: Option[DomainUserPassword]
    def auditDestinationARN: Option[AuditDestinationARN]
    def cacheAttributes
        : Option[zio.aws.storagegateway.model.CacheAttributes.ReadOnly]
    def getFileSystemAssociationARN
        : ZIO[Any, Nothing, FileSystemAssociationARN] =
      ZIO.succeed(fileSystemAssociationARN)
    def getUserName: ZIO[Any, AwsError, DomainUserName] =
      AwsError.unwrapOptionField("userName", userName)
    def getPassword: ZIO[Any, AwsError, DomainUserPassword] =
      AwsError.unwrapOptionField("password", password)
    def getAuditDestinationARN: ZIO[Any, AwsError, AuditDestinationARN] =
      AwsError.unwrapOptionField("auditDestinationARN", auditDestinationARN)
    def getCacheAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.CacheAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("cacheAttributes", cacheAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationRequest
  ) extends zio.aws.storagegateway.model.UpdateFileSystemAssociationRequest.ReadOnly {
    override val fileSystemAssociationARN: FileSystemAssociationARN =
      zio.aws.storagegateway.model.primitives
        .FileSystemAssociationARN(impl.fileSystemAssociationARN())
    override val userName: Option[DomainUserName] = scala
      .Option(impl.userName())
      .map(value =>
        zio.aws.storagegateway.model.primitives.DomainUserName(value)
      )
    override val password: Option[DomainUserPassword] = scala
      .Option(impl.password())
      .map(value =>
        zio.aws.storagegateway.model.primitives.DomainUserPassword(value)
      )
    override val auditDestinationARN: Option[AuditDestinationARN] = scala
      .Option(impl.auditDestinationARN())
      .map(value =>
        zio.aws.storagegateway.model.primitives.AuditDestinationARN(value)
      )
    override val cacheAttributes
        : Option[zio.aws.storagegateway.model.CacheAttributes.ReadOnly] = scala
      .Option(impl.cacheAttributes())
      .map(value => zio.aws.storagegateway.model.CacheAttributes.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationRequest
  ): zio.aws.storagegateway.model.UpdateFileSystemAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
