package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{IqnName, ChapSecret, TargetARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateChapCredentialsRequest(
    targetARN: TargetARN,
    secretToAuthenticateInitiator: ChapSecret,
    initiatorName: IqnName,
    secretToAuthenticateTarget: Option[ChapSecret] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateChapCredentialsRequest = {
    import UpdateChapCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateChapCredentialsRequest
      .builder()
      .targetARN(TargetARN.unwrap(targetARN): java.lang.String)
      .secretToAuthenticateInitiator(
        ChapSecret.unwrap(secretToAuthenticateInitiator): java.lang.String
      )
      .initiatorName(IqnName.unwrap(initiatorName): java.lang.String)
      .optionallyWith(
        secretToAuthenticateTarget.map(value =>
          ChapSecret.unwrap(value): java.lang.String
        )
      )(_.secretToAuthenticateTarget)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateChapCredentialsRequest.ReadOnly =
    zio.aws.storagegateway.model.UpdateChapCredentialsRequest
      .wrap(buildAwsValue())
}
object UpdateChapCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateChapCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.UpdateChapCredentialsRequest =
      zio.aws.storagegateway.model.UpdateChapCredentialsRequest(
        targetARN,
        secretToAuthenticateInitiator,
        initiatorName,
        secretToAuthenticateTarget.map(value => value)
      )
    def targetARN: TargetARN
    def secretToAuthenticateInitiator: ChapSecret
    def initiatorName: IqnName
    def secretToAuthenticateTarget: Option[ChapSecret]
    def getTargetARN: ZIO[Any, Nothing, TargetARN] = ZIO.succeed(targetARN)
    def getSecretToAuthenticateInitiator: ZIO[Any, Nothing, ChapSecret] =
      ZIO.succeed(secretToAuthenticateInitiator)
    def getInitiatorName: ZIO[Any, Nothing, IqnName] =
      ZIO.succeed(initiatorName)
    def getSecretToAuthenticateTarget: ZIO[Any, AwsError, ChapSecret] =
      AwsError.unwrapOptionField(
        "secretToAuthenticateTarget",
        secretToAuthenticateTarget
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateChapCredentialsRequest
  ) extends zio.aws.storagegateway.model.UpdateChapCredentialsRequest.ReadOnly {
    override val targetARN: TargetARN =
      zio.aws.storagegateway.model.primitives.TargetARN(impl.targetARN())
    override val secretToAuthenticateInitiator: ChapSecret =
      zio.aws.storagegateway.model.primitives
        .ChapSecret(impl.secretToAuthenticateInitiator())
    override val initiatorName: IqnName =
      zio.aws.storagegateway.model.primitives.IqnName(impl.initiatorName())
    override val secretToAuthenticateTarget: Option[ChapSecret] = scala
      .Option(impl.secretToAuthenticateTarget())
      .map(value => zio.aws.storagegateway.model.primitives.ChapSecret(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateChapCredentialsRequest
  ): zio.aws.storagegateway.model.UpdateChapCredentialsRequest.ReadOnly =
    new Wrapper(impl)
}
