package zio.aws.storagegateway.model
import java.lang.Integer
import zio.aws.storagegateway.model.primitives.{
  VolumeARN,
  RecurrenceInHours,
  HourOfDay,
  Description,
  GatewayTimezone
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSnapshotScheduleResponse(
    volumeARN: Option[VolumeARN] = None,
    startAt: Option[HourOfDay] = None,
    recurrenceInHours: Option[RecurrenceInHours] = None,
    description: Option[Description] = None,
    timezone: Option[GatewayTimezone] = None,
    tags: Option[Iterable[zio.aws.storagegateway.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeSnapshotScheduleResponse = {
    import DescribeSnapshotScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeSnapshotScheduleResponse
      .builder()
      .optionallyWith(
        volumeARN.map(value => VolumeARN.unwrap(value): java.lang.String)
      )(_.volumeARN)
      .optionallyWith(startAt.map(value => HourOfDay.unwrap(value): Integer))(
        _.startAt
      )
      .optionallyWith(
        recurrenceInHours.map(value => RecurrenceInHours.unwrap(value): Integer)
      )(_.recurrenceInHours)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        timezone.map(value => GatewayTimezone.unwrap(value): java.lang.String)
      )(_.timezone)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeSnapshotScheduleResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeSnapshotScheduleResponse
      .wrap(buildAwsValue())
}
object DescribeSnapshotScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeSnapshotScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeSnapshotScheduleResponse =
      zio.aws.storagegateway.model.DescribeSnapshotScheduleResponse(
        volumeARN.map(value => value),
        startAt.map(value => value),
        recurrenceInHours.map(value => value),
        description.map(value => value),
        timezone.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def volumeARN: Option[VolumeARN]
    def startAt: Option[HourOfDay]
    def recurrenceInHours: Option[RecurrenceInHours]
    def description: Option[Description]
    def timezone: Option[GatewayTimezone]
    def tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]]
    def getVolumeARN: ZIO[Any, AwsError, VolumeARN] =
      AwsError.unwrapOptionField("volumeARN", volumeARN)
    def getStartAt: ZIO[Any, AwsError, HourOfDay] =
      AwsError.unwrapOptionField("startAt", startAt)
    def getRecurrenceInHours: ZIO[Any, AwsError, RecurrenceInHours] =
      AwsError.unwrapOptionField("recurrenceInHours", recurrenceInHours)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTimezone: ZIO[Any, AwsError, GatewayTimezone] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeSnapshotScheduleResponse
  ) extends zio.aws.storagegateway.model.DescribeSnapshotScheduleResponse.ReadOnly {
    override val volumeARN: Option[VolumeARN] = scala
      .Option(impl.volumeARN())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeARN(value))
    override val startAt: Option[HourOfDay] = scala
      .Option(impl.startAt())
      .map(value => zio.aws.storagegateway.model.primitives.HourOfDay(value))
    override val recurrenceInHours: Option[RecurrenceInHours] = scala
      .Option(impl.recurrenceInHours())
      .map(value =>
        zio.aws.storagegateway.model.primitives.RecurrenceInHours(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.storagegateway.model.primitives.Description(value))
    override val timezone: Option[GatewayTimezone] = scala
      .Option(impl.timezone())
      .map(value =>
        zio.aws.storagegateway.model.primitives.GatewayTimezone(value)
      )
    override val tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeSnapshotScheduleResponse
  ): zio.aws.storagegateway.model.DescribeSnapshotScheduleResponse.ReadOnly =
    new Wrapper(impl)
}
