package zio.aws.storagegateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSmbFileSharesResponse(
    smbFileShareInfoList: Option[
      Iterable[zio.aws.storagegateway.model.SMBFileShareInfo]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeSmbFileSharesResponse = {
    import DescribeSmbFileSharesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeSmbFileSharesResponse
      .builder()
      .optionallyWith(
        smbFileShareInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.smbFileShareInfoList)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeSmbFileSharesResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeSmbFileSharesResponse
      .wrap(buildAwsValue())
}
object DescribeSmbFileSharesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeSmbFileSharesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DescribeSmbFileSharesResponse =
      zio.aws.storagegateway.model.DescribeSmbFileSharesResponse(
        smbFileShareInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def smbFileShareInfoList
        : Option[List[zio.aws.storagegateway.model.SMBFileShareInfo.ReadOnly]]
    def getSmbFileShareInfoList: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.SMBFileShareInfo.ReadOnly
    ]] =
      AwsError.unwrapOptionField("smbFileShareInfoList", smbFileShareInfoList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeSmbFileSharesResponse
  ) extends zio.aws.storagegateway.model.DescribeSmbFileSharesResponse.ReadOnly {
    override val smbFileShareInfoList
        : Option[List[zio.aws.storagegateway.model.SMBFileShareInfo.ReadOnly]] =
      scala
        .Option(impl.smbFileShareInfoList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.SMBFileShareInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeSmbFileSharesResponse
  ): zio.aws.storagegateway.model.DescribeSmbFileSharesResponse.ReadOnly =
    new Wrapper(impl)
}
