package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateMaintenanceStartTimeResponse(
    gatewayARN: Option[GatewayARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateMaintenanceStartTimeResponse = {
    import UpdateMaintenanceStartTimeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateMaintenanceStartTimeResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateMaintenanceStartTimeResponse.ReadOnly =
    zio.aws.storagegateway.model.UpdateMaintenanceStartTimeResponse
      .wrap(buildAwsValue())
}
object UpdateMaintenanceStartTimeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateMaintenanceStartTimeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.UpdateMaintenanceStartTimeResponse =
      zio.aws.storagegateway.model
        .UpdateMaintenanceStartTimeResponse(gatewayARN.map(value => value))
    def gatewayARN: Option[GatewayARN]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateMaintenanceStartTimeResponse
  ) extends zio.aws.storagegateway.model.UpdateMaintenanceStartTimeResponse.ReadOnly {
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateMaintenanceStartTimeResponse
  ): zio.aws.storagegateway.model.UpdateMaintenanceStartTimeResponse.ReadOnly =
    new Wrapper(impl)
}
