package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{TapeARN, GatewayARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteTapeRequest(
    gatewayARN: GatewayARN,
    tapeARN: TapeARN,
    bypassGovernanceRetention: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DeleteTapeRequest = {
    import DeleteTapeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DeleteTapeRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .tapeARN(TapeARN.unwrap(tapeARN): java.lang.String)
      .optionallyWith(
        bypassGovernanceRetention.map(value => value: java.lang.Boolean)
      )(_.bypassGovernanceRetention)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.DeleteTapeRequest.ReadOnly =
    zio.aws.storagegateway.model.DeleteTapeRequest.wrap(buildAwsValue())
}
object DeleteTapeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DeleteTapeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DeleteTapeRequest =
      zio.aws.storagegateway.model.DeleteTapeRequest(
        gatewayARN,
        tapeARN,
        bypassGovernanceRetention.map(value => value)
      )
    def gatewayARN: GatewayARN
    def tapeARN: TapeARN
    def bypassGovernanceRetention: Option[Boolean]
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getTapeARN: ZIO[Any, Nothing, TapeARN] = ZIO.succeed(tapeARN)
    def getBypassGovernanceRetention: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("bypassGovernanceRetention", bypassGovernanceRetention)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteTapeRequest
  ) extends zio.aws.storagegateway.model.DeleteTapeRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val tapeARN: TapeARN =
      zio.aws.storagegateway.model.primitives.TapeARN(impl.tapeARN())
    override val bypassGovernanceRetention: Option[Boolean] = scala
      .Option(impl.bypassGovernanceRetention())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteTapeRequest
  ): zio.aws.storagegateway.model.DeleteTapeRequest.ReadOnly = new Wrapper(impl)
}
