package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  DomainUserName,
  FileSystemLocationARN,
  AuditDestinationARN,
  GatewayARN,
  DomainUserPassword,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AssociateFileSystemRequest(
    userName: DomainUserName,
    password: DomainUserPassword,
    clientToken: ClientToken,
    gatewayARN: GatewayARN,
    locationARN: FileSystemLocationARN,
    tags: Option[Iterable[zio.aws.storagegateway.model.Tag]] = None,
    auditDestinationARN: Option[AuditDestinationARN] = None,
    cacheAttributes: Option[zio.aws.storagegateway.model.CacheAttributes] =
      None,
    endpointNetworkConfiguration: Option[
      zio.aws.storagegateway.model.EndpointNetworkConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemRequest = {
    import AssociateFileSystemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemRequest
      .builder()
      .userName(DomainUserName.unwrap(userName): java.lang.String)
      .password(DomainUserPassword.unwrap(password): java.lang.String)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .locationARN(FileSystemLocationARN.unwrap(locationARN): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        auditDestinationARN.map(value =>
          AuditDestinationARN.unwrap(value): java.lang.String
        )
      )(_.auditDestinationARN)
      .optionallyWith(cacheAttributes.map(value => value.buildAwsValue()))(
        _.cacheAttributes
      )
      .optionallyWith(
        endpointNetworkConfiguration.map(value => value.buildAwsValue())
      )(_.endpointNetworkConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.AssociateFileSystemRequest.ReadOnly =
    zio.aws.storagegateway.model.AssociateFileSystemRequest
      .wrap(buildAwsValue())
}
object AssociateFileSystemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.AssociateFileSystemRequest =
      zio.aws.storagegateway.model.AssociateFileSystemRequest(
        userName,
        password,
        clientToken,
        gatewayARN,
        locationARN,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        auditDestinationARN.map(value => value),
        cacheAttributes.map(value => value.asEditable),
        endpointNetworkConfiguration.map(value => value.asEditable)
      )
    def userName: DomainUserName
    def password: DomainUserPassword
    def clientToken: ClientToken
    def gatewayARN: GatewayARN
    def locationARN: FileSystemLocationARN
    def tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]]
    def auditDestinationARN: Option[AuditDestinationARN]
    def cacheAttributes
        : Option[zio.aws.storagegateway.model.CacheAttributes.ReadOnly]
    def endpointNetworkConfiguration: Option[
      zio.aws.storagegateway.model.EndpointNetworkConfiguration.ReadOnly
    ]
    def getUserName: ZIO[Any, Nothing, DomainUserName] = ZIO.succeed(userName)
    def getPassword: ZIO[Any, Nothing, DomainUserPassword] =
      ZIO.succeed(password)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getLocationARN: ZIO[Any, Nothing, FileSystemLocationARN] =
      ZIO.succeed(locationARN)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAuditDestinationARN: ZIO[Any, AwsError, AuditDestinationARN] =
      AwsError.unwrapOptionField("auditDestinationARN", auditDestinationARN)
    def getCacheAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.CacheAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("cacheAttributes", cacheAttributes)
    def getEndpointNetworkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.EndpointNetworkConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "endpointNetworkConfiguration",
      endpointNetworkConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemRequest
  ) extends zio.aws.storagegateway.model.AssociateFileSystemRequest.ReadOnly {
    override val userName: DomainUserName =
      zio.aws.storagegateway.model.primitives.DomainUserName(impl.userName())
    override val password: DomainUserPassword =
      zio.aws.storagegateway.model.primitives
        .DomainUserPassword(impl.password())
    override val clientToken: ClientToken =
      zio.aws.storagegateway.model.primitives.ClientToken(impl.clientToken())
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val locationARN: FileSystemLocationARN =
      zio.aws.storagegateway.model.primitives
        .FileSystemLocationARN(impl.locationARN())
    override val tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.Tag.wrap(item)
          }.toList
        )
    override val auditDestinationARN: Option[AuditDestinationARN] = scala
      .Option(impl.auditDestinationARN())
      .map(value =>
        zio.aws.storagegateway.model.primitives.AuditDestinationARN(value)
      )
    override val cacheAttributes
        : Option[zio.aws.storagegateway.model.CacheAttributes.ReadOnly] = scala
      .Option(impl.cacheAttributes())
      .map(value => zio.aws.storagegateway.model.CacheAttributes.wrap(value))
    override val endpointNetworkConfiguration: Option[
      zio.aws.storagegateway.model.EndpointNetworkConfiguration.ReadOnly
    ] = scala
      .Option(impl.endpointNetworkConfiguration())
      .map(value =>
        zio.aws.storagegateway.model.EndpointNetworkConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemRequest
  ): zio.aws.storagegateway.model.AssociateFileSystemRequest.ReadOnly =
    new Wrapper(impl)
}
