package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  DoubleObject,
  KMSKey,
  VolumeARN,
  DiskId,
  VolumeStatus,
  VolumeId,
  SnapshotId,
  VolumeUsedInBytes,
  CreatedDate,
  TargetName,
  VolumeAttachmentStatus,
  VolumeType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class StorediSCSIVolume(
    volumeARN: Option[VolumeARN] = None,
    volumeId: Option[VolumeId] = None,
    volumeType: Option[VolumeType] = None,
    volumeStatus: Option[VolumeStatus] = None,
    volumeAttachmentStatus: Option[VolumeAttachmentStatus] = None,
    volumeSizeInBytes: Option[Long] = None,
    volumeProgress: Option[DoubleObject] = None,
    volumeDiskId: Option[DiskId] = None,
    sourceSnapshotId: Option[SnapshotId] = None,
    preservedExistingData: Option[Boolean] = None,
    volumeiSCSIAttributes: Option[
      zio.aws.storagegateway.model.VolumeiSCSIAttributes
    ] = None,
    createdDate: Option[CreatedDate] = None,
    volumeUsedInBytes: Option[VolumeUsedInBytes] = None,
    kmsKey: Option[KMSKey] = None,
    targetName: Option[TargetName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.StorediSCSIVolume = {
    import StorediSCSIVolume.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.StorediSCSIVolume
      .builder()
      .optionallyWith(
        volumeARN.map(value => VolumeARN.unwrap(value): java.lang.String)
      )(_.volumeARN)
      .optionallyWith(
        volumeId.map(value => VolumeId.unwrap(value): java.lang.String)
      )(_.volumeId)
      .optionallyWith(
        volumeType.map(value => VolumeType.unwrap(value): java.lang.String)
      )(_.volumeType)
      .optionallyWith(
        volumeStatus.map(value => VolumeStatus.unwrap(value): java.lang.String)
      )(_.volumeStatus)
      .optionallyWith(
        volumeAttachmentStatus.map(value =>
          VolumeAttachmentStatus.unwrap(value): java.lang.String
        )
      )(_.volumeAttachmentStatus)
      .optionallyWith(volumeSizeInBytes.map(value => value: java.lang.Long))(
        _.volumeSizeInBytes
      )
      .optionallyWith(
        volumeProgress.map(value =>
          DoubleObject.unwrap(value): java.lang.Double
        )
      )(_.volumeProgress)
      .optionallyWith(
        volumeDiskId.map(value => DiskId.unwrap(value): java.lang.String)
      )(_.volumeDiskId)
      .optionallyWith(
        sourceSnapshotId.map(value =>
          SnapshotId.unwrap(value): java.lang.String
        )
      )(_.sourceSnapshotId)
      .optionallyWith(
        preservedExistingData.map(value => value: java.lang.Boolean)
      )(_.preservedExistingData)
      .optionallyWith(
        volumeiSCSIAttributes.map(value => value.buildAwsValue())
      )(_.volumeiSCSIAttributes)
      .optionallyWith(
        createdDate.map(value => CreatedDate.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        volumeUsedInBytes.map(value =>
          VolumeUsedInBytes.unwrap(value): java.lang.Long
        )
      )(_.volumeUsedInBytes)
      .optionallyWith(
        kmsKey.map(value => KMSKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(
        targetName.map(value => TargetName.unwrap(value): java.lang.String)
      )(_.targetName)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.StorediSCSIVolume.ReadOnly =
    zio.aws.storagegateway.model.StorediSCSIVolume.wrap(buildAwsValue())
}
object StorediSCSIVolume {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.StorediSCSIVolume
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.StorediSCSIVolume =
      zio.aws.storagegateway.model.StorediSCSIVolume(
        volumeARN.map(value => value),
        volumeId.map(value => value),
        volumeType.map(value => value),
        volumeStatus.map(value => value),
        volumeAttachmentStatus.map(value => value),
        volumeSizeInBytes.map(value => value),
        volumeProgress.map(value => value),
        volumeDiskId.map(value => value),
        sourceSnapshotId.map(value => value),
        preservedExistingData.map(value => value),
        volumeiSCSIAttributes.map(value => value.asEditable),
        createdDate.map(value => value),
        volumeUsedInBytes.map(value => value),
        kmsKey.map(value => value),
        targetName.map(value => value)
      )
    def volumeARN: Option[VolumeARN]
    def volumeId: Option[VolumeId]
    def volumeType: Option[VolumeType]
    def volumeStatus: Option[VolumeStatus]
    def volumeAttachmentStatus: Option[VolumeAttachmentStatus]
    def volumeSizeInBytes: Option[Long]
    def volumeProgress: Option[DoubleObject]
    def volumeDiskId: Option[DiskId]
    def sourceSnapshotId: Option[SnapshotId]
    def preservedExistingData: Option[Boolean]
    def volumeiSCSIAttributes
        : Option[zio.aws.storagegateway.model.VolumeiSCSIAttributes.ReadOnly]
    def createdDate: Option[CreatedDate]
    def volumeUsedInBytes: Option[VolumeUsedInBytes]
    def kmsKey: Option[KMSKey]
    def targetName: Option[TargetName]
    def getVolumeARN: ZIO[Any, AwsError, VolumeARN] =
      AwsError.unwrapOptionField("volumeARN", volumeARN)
    def getVolumeId: ZIO[Any, AwsError, VolumeId] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getVolumeType: ZIO[Any, AwsError, VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getVolumeStatus: ZIO[Any, AwsError, VolumeStatus] =
      AwsError.unwrapOptionField("volumeStatus", volumeStatus)
    def getVolumeAttachmentStatus: ZIO[Any, AwsError, VolumeAttachmentStatus] =
      AwsError.unwrapOptionField(
        "volumeAttachmentStatus",
        volumeAttachmentStatus
      )
    def getVolumeSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("volumeSizeInBytes", volumeSizeInBytes)
    def getVolumeProgress: ZIO[Any, AwsError, DoubleObject] =
      AwsError.unwrapOptionField("volumeProgress", volumeProgress)
    def getVolumeDiskId: ZIO[Any, AwsError, DiskId] =
      AwsError.unwrapOptionField("volumeDiskId", volumeDiskId)
    def getSourceSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("sourceSnapshotId", sourceSnapshotId)
    def getPreservedExistingData: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("preservedExistingData", preservedExistingData)
    def getVolumeiSCSIAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.VolumeiSCSIAttributes.ReadOnly
    ] =
      AwsError.unwrapOptionField("volumeiSCSIAttributes", volumeiSCSIAttributes)
    def getCreatedDate: ZIO[Any, AwsError, CreatedDate] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getVolumeUsedInBytes: ZIO[Any, AwsError, VolumeUsedInBytes] =
      AwsError.unwrapOptionField("volumeUsedInBytes", volumeUsedInBytes)
    def getKmsKey: ZIO[Any, AwsError, KMSKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getTargetName: ZIO[Any, AwsError, TargetName] =
      AwsError.unwrapOptionField("targetName", targetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.StorediSCSIVolume
  ) extends zio.aws.storagegateway.model.StorediSCSIVolume.ReadOnly {
    override val volumeARN: Option[VolumeARN] = scala
      .Option(impl.volumeARN())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeARN(value))
    override val volumeId: Option[VolumeId] = scala
      .Option(impl.volumeId())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeId(value))
    override val volumeType: Option[VolumeType] = scala
      .Option(impl.volumeType())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeType(value))
    override val volumeStatus: Option[VolumeStatus] = scala
      .Option(impl.volumeStatus())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeStatus(value))
    override val volumeAttachmentStatus: Option[VolumeAttachmentStatus] = scala
      .Option(impl.volumeAttachmentStatus())
      .map(value =>
        zio.aws.storagegateway.model.primitives.VolumeAttachmentStatus(value)
      )
    override val volumeSizeInBytes: Option[Long] =
      scala.Option(impl.volumeSizeInBytes()).map(value => value: Long)
    override val volumeProgress: Option[DoubleObject] = scala
      .Option(impl.volumeProgress())
      .map(value => zio.aws.storagegateway.model.primitives.DoubleObject(value))
    override val volumeDiskId: Option[DiskId] = scala
      .Option(impl.volumeDiskId())
      .map(value => zio.aws.storagegateway.model.primitives.DiskId(value))
    override val sourceSnapshotId: Option[SnapshotId] = scala
      .Option(impl.sourceSnapshotId())
      .map(value => zio.aws.storagegateway.model.primitives.SnapshotId(value))
    override val preservedExistingData: Option[Boolean] =
      scala.Option(impl.preservedExistingData()).map(value => value: Boolean)
    override val volumeiSCSIAttributes
        : Option[zio.aws.storagegateway.model.VolumeiSCSIAttributes.ReadOnly] =
      scala
        .Option(impl.volumeiSCSIAttributes())
        .map(value =>
          zio.aws.storagegateway.model.VolumeiSCSIAttributes.wrap(value)
        )
    override val createdDate: Option[CreatedDate] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.storagegateway.model.primitives.CreatedDate(value))
    override val volumeUsedInBytes: Option[VolumeUsedInBytes] = scala
      .Option(impl.volumeUsedInBytes())
      .map(value =>
        zio.aws.storagegateway.model.primitives.VolumeUsedInBytes(value)
      )
    override val kmsKey: Option[KMSKey] = scala
      .Option(impl.kmsKey())
      .map(value => zio.aws.storagegateway.model.primitives.KMSKey(value))
    override val targetName: Option[TargetName] = scala
      .Option(impl.targetName())
      .map(value => zio.aws.storagegateway.model.primitives.TargetName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.StorediSCSIVolume
  ): zio.aws.storagegateway.model.StorediSCSIVolume.ReadOnly = new Wrapper(impl)
}
