package zio.aws.storagegateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NetworkInterface(
    ipv4Address: Option[String] = None,
    macAddress: Option[String] = None,
    ipv6Address: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.NetworkInterface = {
    import NetworkInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.NetworkInterface
      .builder()
      .optionallyWith(ipv4Address.map(value => value: java.lang.String))(
        _.ipv4Address
      )
      .optionallyWith(macAddress.map(value => value: java.lang.String))(
        _.macAddress
      )
      .optionallyWith(ipv6Address.map(value => value: java.lang.String))(
        _.ipv6Address
      )
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.NetworkInterface.ReadOnly =
    zio.aws.storagegateway.model.NetworkInterface.wrap(buildAwsValue())
}
object NetworkInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.NetworkInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.NetworkInterface =
      zio.aws.storagegateway.model.NetworkInterface(
        ipv4Address.map(value => value),
        macAddress.map(value => value),
        ipv6Address.map(value => value)
      )
    def ipv4Address: Option[String]
    def macAddress: Option[String]
    def ipv6Address: Option[String]
    def getIpv4Address: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv4Address", ipv4Address)
    def getMacAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("macAddress", macAddress)
    def getIpv6Address: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6Address", ipv6Address)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.NetworkInterface
  ) extends zio.aws.storagegateway.model.NetworkInterface.ReadOnly {
    override val ipv4Address: Option[String] =
      scala.Option(impl.ipv4Address()).map(value => value: String)
    override val macAddress: Option[String] =
      scala.Option(impl.macAddress()).map(value => value: String)
    override val ipv6Address: Option[String] =
      scala.Option(impl.ipv6Address()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.NetworkInterface
  ): zio.aws.storagegateway.model.NetworkInterface.ReadOnly = new Wrapper(impl)
}
