package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTapesResponse(
    tapeInfos: Option[Iterable[zio.aws.storagegateway.model.TapeInfo]] = None,
    marker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListTapesResponse = {
    import ListTapesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListTapesResponse
      .builder()
      .optionallyWith(
        tapeInfos.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tapeInfos)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.ListTapesResponse.ReadOnly =
    zio.aws.storagegateway.model.ListTapesResponse.wrap(buildAwsValue())
}
object ListTapesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListTapesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ListTapesResponse =
      zio.aws.storagegateway.model.ListTapesResponse(
        tapeInfos.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def tapeInfos: Option[List[zio.aws.storagegateway.model.TapeInfo.ReadOnly]]
    def marker: Option[Marker]
    def getTapeInfos: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.TapeInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("tapeInfos", tapeInfos)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListTapesResponse
  ) extends zio.aws.storagegateway.model.ListTapesResponse.ReadOnly {
    override val tapeInfos
        : Option[List[zio.aws.storagegateway.model.TapeInfo.ReadOnly]] = scala
      .Option(impl.tapeInfos())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.TapeInfo.wrap(item)
        }.toList
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListTapesResponse
  ): zio.aws.storagegateway.model.ListTapesResponse.ReadOnly = new Wrapper(impl)
}
