package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  BandwidthDownloadRateLimit,
  BandwidthUploadRateLimit,
  GatewayARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeBandwidthRateLimitResponse(
    gatewayARN: Option[GatewayARN] = None,
    averageUploadRateLimitInBitsPerSec: Option[BandwidthUploadRateLimit] = None,
    averageDownloadRateLimitInBitsPerSec: Option[BandwidthDownloadRateLimit] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitResponse = {
    import DescribeBandwidthRateLimitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        averageUploadRateLimitInBitsPerSec.map(value =>
          BandwidthUploadRateLimit.unwrap(value): java.lang.Long
        )
      )(_.averageUploadRateLimitInBitsPerSec)
      .optionallyWith(
        averageDownloadRateLimitInBitsPerSec.map(value =>
          BandwidthDownloadRateLimit.unwrap(value): java.lang.Long
        )
      )(_.averageDownloadRateLimitInBitsPerSec)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeBandwidthRateLimitResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeBandwidthRateLimitResponse
      .wrap(buildAwsValue())
}
object DescribeBandwidthRateLimitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeBandwidthRateLimitResponse =
      zio.aws.storagegateway.model.DescribeBandwidthRateLimitResponse(
        gatewayARN.map(value => value),
        averageUploadRateLimitInBitsPerSec.map(value => value),
        averageDownloadRateLimitInBitsPerSec.map(value => value)
      )
    def gatewayARN: Option[GatewayARN]
    def averageUploadRateLimitInBitsPerSec: Option[BandwidthUploadRateLimit]
    def averageDownloadRateLimitInBitsPerSec: Option[BandwidthDownloadRateLimit]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getAverageUploadRateLimitInBitsPerSec
        : ZIO[Any, AwsError, BandwidthUploadRateLimit] =
      AwsError.unwrapOptionField(
        "averageUploadRateLimitInBitsPerSec",
        averageUploadRateLimitInBitsPerSec
      )
    def getAverageDownloadRateLimitInBitsPerSec
        : ZIO[Any, AwsError, BandwidthDownloadRateLimit] =
      AwsError.unwrapOptionField(
        "averageDownloadRateLimitInBitsPerSec",
        averageDownloadRateLimitInBitsPerSec
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitResponse
  ) extends zio.aws.storagegateway.model.DescribeBandwidthRateLimitResponse.ReadOnly {
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val averageUploadRateLimitInBitsPerSec
        : Option[BandwidthUploadRateLimit] = scala
      .Option(impl.averageUploadRateLimitInBitsPerSec())
      .map(value =>
        zio.aws.storagegateway.model.primitives.BandwidthUploadRateLimit(value)
      )
    override val averageDownloadRateLimitInBitsPerSec
        : Option[BandwidthDownloadRateLimit] = scala
      .Option(impl.averageDownloadRateLimitInBitsPerSec())
      .map(value =>
        zio.aws.storagegateway.model.primitives
          .BandwidthDownloadRateLimit(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitResponse
  ): zio.aws.storagegateway.model.DescribeBandwidthRateLimitResponse.ReadOnly =
    new Wrapper(impl)
}
