package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.TapeARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteTapeArchiveRequest(
    tapeARN: TapeARN,
    bypassGovernanceRetention: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DeleteTapeArchiveRequest = {
    import DeleteTapeArchiveRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DeleteTapeArchiveRequest
      .builder()
      .tapeARN(TapeARN.unwrap(tapeARN): java.lang.String)
      .optionallyWith(
        bypassGovernanceRetention.map(value => value: java.lang.Boolean)
      )(_.bypassGovernanceRetention)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DeleteTapeArchiveRequest.ReadOnly =
    zio.aws.storagegateway.model.DeleteTapeArchiveRequest.wrap(buildAwsValue())
}
object DeleteTapeArchiveRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DeleteTapeArchiveRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DeleteTapeArchiveRequest =
      zio.aws.storagegateway.model.DeleteTapeArchiveRequest(
        tapeARN,
        bypassGovernanceRetention.map(value => value)
      )
    def tapeARN: TapeARN
    def bypassGovernanceRetention: Option[Boolean]
    def getTapeARN: ZIO[Any, Nothing, TapeARN] = ZIO.succeed(tapeARN)
    def getBypassGovernanceRetention: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("bypassGovernanceRetention", bypassGovernanceRetention)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteTapeArchiveRequest
  ) extends zio.aws.storagegateway.model.DeleteTapeArchiveRequest.ReadOnly {
    override val tapeARN: TapeARN =
      zio.aws.storagegateway.model.primitives.TapeARN(impl.tapeARN())
    override val bypassGovernanceRetention: Option[Boolean] = scala
      .Option(impl.bypassGovernanceRetention())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteTapeArchiveRequest
  ): zio.aws.storagegateway.model.DeleteTapeArchiveRequest.ReadOnly =
    new Wrapper(impl)
}
