package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{DiskId, GatewayARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AddWorkingStorageRequest(
    gatewayARN: GatewayARN,
    diskIds: Iterable[DiskId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.AddWorkingStorageRequest = {
    import AddWorkingStorageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.AddWorkingStorageRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .diskIds(diskIds.map { item =>
        DiskId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.AddWorkingStorageRequest.ReadOnly =
    zio.aws.storagegateway.model.AddWorkingStorageRequest.wrap(buildAwsValue())
}
object AddWorkingStorageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.AddWorkingStorageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.AddWorkingStorageRequest =
      zio.aws.storagegateway.model.AddWorkingStorageRequest(gatewayARN, diskIds)
    def gatewayARN: GatewayARN
    def diskIds: List[DiskId]
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getDiskIds: ZIO[Any, Nothing, List[DiskId]] = ZIO.succeed(diskIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.AddWorkingStorageRequest
  ) extends zio.aws.storagegateway.model.AddWorkingStorageRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val diskIds: List[DiskId] = impl
      .diskIds()
      .asScala
      .map { item =>
        zio.aws.storagegateway.model.primitives.DiskId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.AddWorkingStorageRequest
  ): zio.aws.storagegateway.model.AddWorkingStorageRequest.ReadOnly =
    new Wrapper(impl)
}
