package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ActivateGatewayResponse(
    gatewayARN: Option[GatewayARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ActivateGatewayResponse = {
    import ActivateGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ActivateGatewayResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.ActivateGatewayResponse.ReadOnly =
    zio.aws.storagegateway.model.ActivateGatewayResponse.wrap(buildAwsValue())
}
object ActivateGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ActivateGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ActivateGatewayResponse =
      zio.aws.storagegateway.model
        .ActivateGatewayResponse(gatewayARN.map(value => value))
    def gatewayARN: Option[GatewayARN]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ActivateGatewayResponse
  ) extends zio.aws.storagegateway.model.ActivateGatewayResponse.ReadOnly {
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ActivateGatewayResponse
  ): zio.aws.storagegateway.model.ActivateGatewayResponse.ReadOnly =
    new Wrapper(impl)
}
