package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{Folder, FileShareARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RefreshCacheRequest(
    fileShareARN: FileShareARN,
    folderList: Option[Iterable[Folder]] = None,
    recursive: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.RefreshCacheRequest = {
    import RefreshCacheRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.RefreshCacheRequest
      .builder()
      .fileShareARN(FileShareARN.unwrap(fileShareARN): java.lang.String)
      .optionallyWith(
        folderList.map(value =>
          value.map { item =>
            Folder.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.folderList)
      .optionallyWith(recursive.map(value => value: java.lang.Boolean))(
        _.recursive
      )
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.RefreshCacheRequest.ReadOnly =
    zio.aws.storagegateway.model.RefreshCacheRequest.wrap(buildAwsValue())
}
object RefreshCacheRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.RefreshCacheRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.RefreshCacheRequest =
      zio.aws.storagegateway.model.RefreshCacheRequest(
        fileShareARN,
        folderList.map(value => value),
        recursive.map(value => value)
      )
    def fileShareARN: FileShareARN
    def folderList: Option[List[Folder]]
    def recursive: Option[Boolean]
    def getFileShareARN: ZIO[Any, Nothing, FileShareARN] =
      ZIO.succeed(fileShareARN)
    def getFolderList: ZIO[Any, AwsError, List[Folder]] =
      AwsError.unwrapOptionField("folderList", folderList)
    def getRecursive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("recursive", recursive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.RefreshCacheRequest
  ) extends zio.aws.storagegateway.model.RefreshCacheRequest.ReadOnly {
    override val fileShareARN: FileShareARN =
      zio.aws.storagegateway.model.primitives.FileShareARN(impl.fileShareARN())
    override val folderList: Option[List[Folder]] = scala
      .Option(impl.folderList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.primitives.Folder(item)
        }.toList
      )
    override val recursive: Option[Boolean] =
      scala.Option(impl.recursive()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.RefreshCacheRequest
  ): zio.aws.storagegateway.model.RefreshCacheRequest.ReadOnly = new Wrapper(
    impl
  )
}
