package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListFileSystemAssociationsResponse(
    marker: Option[Marker] = None,
    nextMarker: Option[Marker] = None,
    fileSystemAssociationSummaryList: Option[
      Iterable[zio.aws.storagegateway.model.FileSystemAssociationSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsResponse = {
    import ListFileSystemAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsResponse
      .builder()
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        fileSystemAssociationSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemAssociationSummaryList)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.ListFileSystemAssociationsResponse.ReadOnly =
    zio.aws.storagegateway.model.ListFileSystemAssociationsResponse
      .wrap(buildAwsValue())
}
object ListFileSystemAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.ListFileSystemAssociationsResponse =
      zio.aws.storagegateway.model.ListFileSystemAssociationsResponse(
        marker.map(value => value),
        nextMarker.map(value => value),
        fileSystemAssociationSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[Marker]
    def nextMarker: Option[Marker]
    def fileSystemAssociationSummaryList: Option[
      List[zio.aws.storagegateway.model.FileSystemAssociationSummary.ReadOnly]
    ]
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getFileSystemAssociationSummaryList: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.FileSystemAssociationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "fileSystemAssociationSummaryList",
      fileSystemAssociationSummaryList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsResponse
  ) extends zio.aws.storagegateway.model.ListFileSystemAssociationsResponse.ReadOnly {
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
    override val nextMarker: Option[Marker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
    override val fileSystemAssociationSummaryList: Option[
      List[zio.aws.storagegateway.model.FileSystemAssociationSummary.ReadOnly]
    ] = scala
      .Option(impl.fileSystemAssociationSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.FileSystemAssociationSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsResponse
  ): zio.aws.storagegateway.model.ListFileSystemAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
