package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  StorageClass,
  KMSKey,
  AuditDestinationARN,
  FileShareName,
  DNSHostName,
  Squash,
  RegionId,
  GatewayARN,
  IPV4AddressCIDR,
  LocationARN,
  ClientToken,
  NotificationPolicy,
  Role
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateNfsFileShareRequest(
    clientToken: ClientToken,
    nfsFileShareDefaults: Option[
      zio.aws.storagegateway.model.NFSFileShareDefaults
    ] = None,
    gatewayARN: GatewayARN,
    kmsEncrypted: Option[Boolean] = None,
    kmsKey: Option[KMSKey] = None,
    role: Role,
    locationARN: LocationARN,
    defaultStorageClass: Option[StorageClass] = None,
    objectACL: Option[zio.aws.storagegateway.model.ObjectACL] = None,
    clientList: Option[Iterable[IPV4AddressCIDR]] = None,
    squash: Option[Squash] = None,
    readOnly: Option[Boolean] = None,
    guessMIMETypeEnabled: Option[Boolean] = None,
    requesterPays: Option[Boolean] = None,
    tags: Option[Iterable[zio.aws.storagegateway.model.Tag]] = None,
    fileShareName: Option[FileShareName] = None,
    cacheAttributes: Option[zio.aws.storagegateway.model.CacheAttributes] =
      None,
    notificationPolicy: Option[NotificationPolicy] = None,
    vpcEndpointDNSName: Option[DNSHostName] = None,
    bucketRegion: Option[RegionId] = None,
    auditDestinationARN: Option[AuditDestinationARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CreateNfsFileShareRequest = {
    import CreateNfsFileShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CreateNfsFileShareRequest
      .builder()
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .optionallyWith(nfsFileShareDefaults.map(value => value.buildAwsValue()))(
        _.nfsFileShareDefaults
      )
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .optionallyWith(kmsEncrypted.map(value => value: java.lang.Boolean))(
        _.kmsEncrypted
      )
      .optionallyWith(
        kmsKey.map(value => KMSKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .role(Role.unwrap(role): java.lang.String)
      .locationARN(LocationARN.unwrap(locationARN): java.lang.String)
      .optionallyWith(
        defaultStorageClass.map(value =>
          StorageClass.unwrap(value): java.lang.String
        )
      )(_.defaultStorageClass)
      .optionallyWith(objectACL.map(value => value.unwrap))(_.objectACL)
      .optionallyWith(
        clientList.map(value =>
          value.map { item =>
            IPV4AddressCIDR.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.clientList)
      .optionallyWith(
        squash.map(value => Squash.unwrap(value): java.lang.String)
      )(_.squash)
      .optionallyWith(readOnly.map(value => value: java.lang.Boolean))(
        _.readOnly
      )
      .optionallyWith(
        guessMIMETypeEnabled.map(value => value: java.lang.Boolean)
      )(_.guessMIMETypeEnabled)
      .optionallyWith(requesterPays.map(value => value: java.lang.Boolean))(
        _.requesterPays
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        fileShareName.map(value =>
          FileShareName.unwrap(value): java.lang.String
        )
      )(_.fileShareName)
      .optionallyWith(cacheAttributes.map(value => value.buildAwsValue()))(
        _.cacheAttributes
      )
      .optionallyWith(
        notificationPolicy.map(value =>
          NotificationPolicy.unwrap(value): java.lang.String
        )
      )(_.notificationPolicy)
      .optionallyWith(
        vpcEndpointDNSName.map(value =>
          DNSHostName.unwrap(value): java.lang.String
        )
      )(_.vpcEndpointDNSName)
      .optionallyWith(
        bucketRegion.map(value => RegionId.unwrap(value): java.lang.String)
      )(_.bucketRegion)
      .optionallyWith(
        auditDestinationARN.map(value =>
          AuditDestinationARN.unwrap(value): java.lang.String
        )
      )(_.auditDestinationARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.CreateNfsFileShareRequest.ReadOnly =
    zio.aws.storagegateway.model.CreateNfsFileShareRequest.wrap(buildAwsValue())
}
object CreateNfsFileShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CreateNfsFileShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.CreateNfsFileShareRequest =
      zio.aws.storagegateway.model.CreateNfsFileShareRequest(
        clientToken,
        nfsFileShareDefaults.map(value => value.asEditable),
        gatewayARN,
        kmsEncrypted.map(value => value),
        kmsKey.map(value => value),
        role,
        locationARN,
        defaultStorageClass.map(value => value),
        objectACL.map(value => value),
        clientList.map(value => value),
        squash.map(value => value),
        readOnly.map(value => value),
        guessMIMETypeEnabled.map(value => value),
        requesterPays.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        fileShareName.map(value => value),
        cacheAttributes.map(value => value.asEditable),
        notificationPolicy.map(value => value),
        vpcEndpointDNSName.map(value => value),
        bucketRegion.map(value => value),
        auditDestinationARN.map(value => value)
      )
    def clientToken: ClientToken
    def nfsFileShareDefaults
        : Option[zio.aws.storagegateway.model.NFSFileShareDefaults.ReadOnly]
    def gatewayARN: GatewayARN
    def kmsEncrypted: Option[Boolean]
    def kmsKey: Option[KMSKey]
    def role: Role
    def locationARN: LocationARN
    def defaultStorageClass: Option[StorageClass]
    def objectACL: Option[zio.aws.storagegateway.model.ObjectACL]
    def clientList: Option[List[IPV4AddressCIDR]]
    def squash: Option[Squash]
    def readOnly: Option[Boolean]
    def guessMIMETypeEnabled: Option[Boolean]
    def requesterPays: Option[Boolean]
    def tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]]
    def fileShareName: Option[FileShareName]
    def cacheAttributes
        : Option[zio.aws.storagegateway.model.CacheAttributes.ReadOnly]
    def notificationPolicy: Option[NotificationPolicy]
    def vpcEndpointDNSName: Option[DNSHostName]
    def bucketRegion: Option[RegionId]
    def auditDestinationARN: Option[AuditDestinationARN]
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
    def getNfsFileShareDefaults: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.NFSFileShareDefaults.ReadOnly
    ] = AwsError.unwrapOptionField("nfsFileShareDefaults", nfsFileShareDefaults)
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getKmsEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("kmsEncrypted", kmsEncrypted)
    def getKmsKey: ZIO[Any, AwsError, KMSKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getRole: ZIO[Any, Nothing, Role] = ZIO.succeed(role)
    def getLocationARN: ZIO[Any, Nothing, LocationARN] =
      ZIO.succeed(locationARN)
    def getDefaultStorageClass: ZIO[Any, AwsError, StorageClass] =
      AwsError.unwrapOptionField("defaultStorageClass", defaultStorageClass)
    def getObjectACL
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.ObjectACL] =
      AwsError.unwrapOptionField("objectACL", objectACL)
    def getClientList: ZIO[Any, AwsError, List[IPV4AddressCIDR]] =
      AwsError.unwrapOptionField("clientList", clientList)
    def getSquash: ZIO[Any, AwsError, Squash] =
      AwsError.unwrapOptionField("squash", squash)
    def getReadOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("readOnly", readOnly)
    def getGuessMIMETypeEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("guessMIMETypeEnabled", guessMIMETypeEnabled)
    def getRequesterPays: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requesterPays", requesterPays)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getFileShareName: ZIO[Any, AwsError, FileShareName] =
      AwsError.unwrapOptionField("fileShareName", fileShareName)
    def getCacheAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.CacheAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("cacheAttributes", cacheAttributes)
    def getNotificationPolicy: ZIO[Any, AwsError, NotificationPolicy] =
      AwsError.unwrapOptionField("notificationPolicy", notificationPolicy)
    def getVpcEndpointDNSName: ZIO[Any, AwsError, DNSHostName] =
      AwsError.unwrapOptionField("vpcEndpointDNSName", vpcEndpointDNSName)
    def getBucketRegion: ZIO[Any, AwsError, RegionId] =
      AwsError.unwrapOptionField("bucketRegion", bucketRegion)
    def getAuditDestinationARN: ZIO[Any, AwsError, AuditDestinationARN] =
      AwsError.unwrapOptionField("auditDestinationARN", auditDestinationARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateNfsFileShareRequest
  ) extends zio.aws.storagegateway.model.CreateNfsFileShareRequest.ReadOnly {
    override val clientToken: ClientToken =
      zio.aws.storagegateway.model.primitives.ClientToken(impl.clientToken())
    override val nfsFileShareDefaults
        : Option[zio.aws.storagegateway.model.NFSFileShareDefaults.ReadOnly] =
      scala
        .Option(impl.nfsFileShareDefaults())
        .map(value =>
          zio.aws.storagegateway.model.NFSFileShareDefaults.wrap(value)
        )
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val kmsEncrypted: Option[Boolean] =
      scala.Option(impl.kmsEncrypted()).map(value => value: Boolean)
    override val kmsKey: Option[KMSKey] = scala
      .Option(impl.kmsKey())
      .map(value => zio.aws.storagegateway.model.primitives.KMSKey(value))
    override val role: Role =
      zio.aws.storagegateway.model.primitives.Role(impl.role())
    override val locationARN: LocationARN =
      zio.aws.storagegateway.model.primitives.LocationARN(impl.locationARN())
    override val defaultStorageClass: Option[StorageClass] = scala
      .Option(impl.defaultStorageClass())
      .map(value => zio.aws.storagegateway.model.primitives.StorageClass(value))
    override val objectACL: Option[zio.aws.storagegateway.model.ObjectACL] =
      scala
        .Option(impl.objectACL())
        .map(value => zio.aws.storagegateway.model.ObjectACL.wrap(value))
    override val clientList: Option[List[IPV4AddressCIDR]] = scala
      .Option(impl.clientList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.primitives.IPV4AddressCIDR(item)
        }.toList
      )
    override val squash: Option[Squash] = scala
      .Option(impl.squash())
      .map(value => zio.aws.storagegateway.model.primitives.Squash(value))
    override val readOnly: Option[Boolean] =
      scala.Option(impl.readOnly()).map(value => value: Boolean)
    override val guessMIMETypeEnabled: Option[Boolean] =
      scala.Option(impl.guessMIMETypeEnabled()).map(value => value: Boolean)
    override val requesterPays: Option[Boolean] =
      scala.Option(impl.requesterPays()).map(value => value: Boolean)
    override val tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.Tag.wrap(item)
          }.toList
        )
    override val fileShareName: Option[FileShareName] = scala
      .Option(impl.fileShareName())
      .map(value =>
        zio.aws.storagegateway.model.primitives.FileShareName(value)
      )
    override val cacheAttributes
        : Option[zio.aws.storagegateway.model.CacheAttributes.ReadOnly] = scala
      .Option(impl.cacheAttributes())
      .map(value => zio.aws.storagegateway.model.CacheAttributes.wrap(value))
    override val notificationPolicy: Option[NotificationPolicy] = scala
      .Option(impl.notificationPolicy())
      .map(value =>
        zio.aws.storagegateway.model.primitives.NotificationPolicy(value)
      )
    override val vpcEndpointDNSName: Option[DNSHostName] = scala
      .Option(impl.vpcEndpointDNSName())
      .map(value => zio.aws.storagegateway.model.primitives.DNSHostName(value))
    override val bucketRegion: Option[RegionId] = scala
      .Option(impl.bucketRegion())
      .map(value => zio.aws.storagegateway.model.primitives.RegionId(value))
    override val auditDestinationARN: Option[AuditDestinationARN] = scala
      .Option(impl.auditDestinationARN())
      .map(value =>
        zio.aws.storagegateway.model.primitives.AuditDestinationARN(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateNfsFileShareRequest
  ): zio.aws.storagegateway.model.CreateNfsFileShareRequest.ReadOnly =
    new Wrapper(impl)
}
