package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateGatewayInformationResponse(
    gatewayARN: Option[GatewayARN] = None,
    gatewayName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateGatewayInformationResponse = {
    import UpdateGatewayInformationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateGatewayInformationResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(gatewayName.map(value => value: java.lang.String))(
        _.gatewayName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateGatewayInformationResponse.ReadOnly =
    zio.aws.storagegateway.model.UpdateGatewayInformationResponse
      .wrap(buildAwsValue())
}
object UpdateGatewayInformationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateGatewayInformationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.UpdateGatewayInformationResponse =
      zio.aws.storagegateway.model.UpdateGatewayInformationResponse(
        gatewayARN.map(value => value),
        gatewayName.map(value => value)
      )
    def gatewayARN: Option[GatewayARN]
    def gatewayName: Option[String]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getGatewayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("gatewayName", gatewayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateGatewayInformationResponse
  ) extends zio.aws.storagegateway.model.UpdateGatewayInformationResponse.ReadOnly {
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val gatewayName: Option[String] =
      scala.Option(impl.gatewayName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateGatewayInformationResponse
  ): zio.aws.storagegateway.model.UpdateGatewayInformationResponse.ReadOnly =
    new Wrapper(impl)
}
