package zio.aws.storagegateway.model
import scala.jdk.CollectionConverters.*
sealed trait ObjectACL {
  def unwrap: software.amazon.awssdk.services.storagegateway.model.ObjectACL
}
object ObjectACL {
  def wrap(
      value: software.amazon.awssdk.services.storagegateway.model.ObjectACL
  ): zio.aws.storagegateway.model.ObjectACL = value match {
    case software.amazon.awssdk.services.storagegateway.model.ObjectACL.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.storagegateway.model.ObjectACL.PRIVATE =>
      val r = `private`
      r
    case software.amazon.awssdk.services.storagegateway.model.ObjectACL.PUBLIC_READ =>
      val r = `public-read`
      r
    case software.amazon.awssdk.services.storagegateway.model.ObjectACL.PUBLIC_READ_WRITE =>
      val r = `public-read-write`
      r
    case software.amazon.awssdk.services.storagegateway.model.ObjectACL.AUTHENTICATED_READ =>
      val r = `authenticated-read`
      r
    case software.amazon.awssdk.services.storagegateway.model.ObjectACL.BUCKET_OWNER_READ =>
      val r = `bucket-owner-read`
      r
    case software.amazon.awssdk.services.storagegateway.model.ObjectACL.BUCKET_OWNER_FULL_CONTROL =>
      val r = `bucket-owner-full-control`
      r
    case software.amazon.awssdk.services.storagegateway.model.ObjectACL.AWS_EXEC_READ =>
      val r = `aws-exec-read`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.storagegateway.model.ObjectACL {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.ObjectACL =
      software.amazon.awssdk.services.storagegateway.model.ObjectACL.UNKNOWN_TO_SDK_VERSION
  }
  case object `private` extends zio.aws.storagegateway.model.ObjectACL {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.ObjectACL =
      software.amazon.awssdk.services.storagegateway.model.ObjectACL.PRIVATE
  }
  case object `public-read` extends zio.aws.storagegateway.model.ObjectACL {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.ObjectACL =
      software.amazon.awssdk.services.storagegateway.model.ObjectACL.PUBLIC_READ
  }
  case object `public-read-write`
      extends zio.aws.storagegateway.model.ObjectACL {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.ObjectACL =
      software.amazon.awssdk.services.storagegateway.model.ObjectACL.PUBLIC_READ_WRITE
  }
  case object `authenticated-read`
      extends zio.aws.storagegateway.model.ObjectACL {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.ObjectACL =
      software.amazon.awssdk.services.storagegateway.model.ObjectACL.AUTHENTICATED_READ
  }
  case object `bucket-owner-read`
      extends zio.aws.storagegateway.model.ObjectACL {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.ObjectACL =
      software.amazon.awssdk.services.storagegateway.model.ObjectACL.BUCKET_OWNER_READ
  }
  case object `bucket-owner-full-control`
      extends zio.aws.storagegateway.model.ObjectACL {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.ObjectACL =
      software.amazon.awssdk.services.storagegateway.model.ObjectACL.BUCKET_OWNER_FULL_CONTROL
  }
  case object `aws-exec-read` extends zio.aws.storagegateway.model.ObjectACL {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.ObjectACL =
      software.amazon.awssdk.services.storagegateway.model.ObjectACL.AWS_EXEC_READ
  }
}
