package zio.aws.storagegateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeStorediScsiVolumesResponse(
    storediSCSIVolumes: Option[
      Iterable[zio.aws.storagegateway.model.StorediSCSIVolume]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeStorediScsiVolumesResponse = {
    import DescribeStorediScsiVolumesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeStorediScsiVolumesResponse
      .builder()
      .optionallyWith(
        storediSCSIVolumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storediSCSIVolumes)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeStorediScsiVolumesResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeStorediScsiVolumesResponse
      .wrap(buildAwsValue())
}
object DescribeStorediScsiVolumesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeStorediScsiVolumesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeStorediScsiVolumesResponse =
      zio.aws.storagegateway.model.DescribeStorediScsiVolumesResponse(
        storediSCSIVolumes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def storediSCSIVolumes
        : Option[List[zio.aws.storagegateway.model.StorediSCSIVolume.ReadOnly]]
    def getStorediSCSIVolumes: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.StorediSCSIVolume.ReadOnly
    ]] = AwsError.unwrapOptionField("storediSCSIVolumes", storediSCSIVolumes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeStorediScsiVolumesResponse
  ) extends zio.aws.storagegateway.model.DescribeStorediScsiVolumesResponse.ReadOnly {
    override val storediSCSIVolumes: Option[
      List[zio.aws.storagegateway.model.StorediSCSIVolume.ReadOnly]
    ] = scala
      .Option(impl.storediSCSIVolumes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.StorediSCSIVolume.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeStorediScsiVolumesResponse
  ): zio.aws.storagegateway.model.DescribeStorediScsiVolumesResponse.ReadOnly =
    new Wrapper(impl)
}
