package zio.aws.storagegateway.model
import java.lang.Integer
import zio.aws.storagegateway.model.primitives.{
  RetentionLockTimeInDays,
  PoolName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateTapePoolRequest(
    poolName: PoolName,
    storageClass: zio.aws.storagegateway.model.TapeStorageClass,
    retentionLockType: Option[zio.aws.storagegateway.model.RetentionLockType] =
      None,
    retentionLockTimeInDays: Option[RetentionLockTimeInDays] = None,
    tags: Option[Iterable[zio.aws.storagegateway.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CreateTapePoolRequest = {
    import CreateTapePoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CreateTapePoolRequest
      .builder()
      .poolName(PoolName.unwrap(poolName): java.lang.String)
      .storageClass(storageClass.unwrap)
      .optionallyWith(retentionLockType.map(value => value.unwrap))(
        _.retentionLockType
      )
      .optionallyWith(
        retentionLockTimeInDays.map(value =>
          RetentionLockTimeInDays.unwrap(value): Integer
        )
      )(_.retentionLockTimeInDays)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.CreateTapePoolRequest.ReadOnly =
    zio.aws.storagegateway.model.CreateTapePoolRequest.wrap(buildAwsValue())
}
object CreateTapePoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CreateTapePoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.CreateTapePoolRequest =
      zio.aws.storagegateway.model.CreateTapePoolRequest(
        poolName,
        storageClass,
        retentionLockType.map(value => value),
        retentionLockTimeInDays.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def poolName: PoolName
    def storageClass: zio.aws.storagegateway.model.TapeStorageClass
    def retentionLockType
        : Option[zio.aws.storagegateway.model.RetentionLockType]
    def retentionLockTimeInDays: Option[RetentionLockTimeInDays]
    def tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]]
    def getPoolName: ZIO[Any, Nothing, PoolName] = ZIO.succeed(poolName)
    def getStorageClass
        : ZIO[Any, Nothing, zio.aws.storagegateway.model.TapeStorageClass] =
      ZIO.succeed(storageClass)
    def getRetentionLockType
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.RetentionLockType] =
      AwsError.unwrapOptionField("retentionLockType", retentionLockType)
    def getRetentionLockTimeInDays
        : ZIO[Any, AwsError, RetentionLockTimeInDays] = AwsError
      .unwrapOptionField("retentionLockTimeInDays", retentionLockTimeInDays)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateTapePoolRequest
  ) extends zio.aws.storagegateway.model.CreateTapePoolRequest.ReadOnly {
    override val poolName: PoolName =
      zio.aws.storagegateway.model.primitives.PoolName(impl.poolName())
    override val storageClass: zio.aws.storagegateway.model.TapeStorageClass =
      zio.aws.storagegateway.model.TapeStorageClass.wrap(impl.storageClass())
    override val retentionLockType
        : Option[zio.aws.storagegateway.model.RetentionLockType] = scala
      .Option(impl.retentionLockType())
      .map(value => zio.aws.storagegateway.model.RetentionLockType.wrap(value))
    override val retentionLockTimeInDays: Option[RetentionLockTimeInDays] =
      scala
        .Option(impl.retentionLockTimeInDays())
        .map(value =>
          zio.aws.storagegateway.model.primitives.RetentionLockTimeInDays(value)
        )
    override val tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateTapePoolRequest
  ): zio.aws.storagegateway.model.CreateTapePoolRequest.ReadOnly = new Wrapper(
    impl
  )
}
