package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AddWorkingStorageResponse(
    gatewayARN: Option[GatewayARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.AddWorkingStorageResponse = {
    import AddWorkingStorageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.AddWorkingStorageResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.AddWorkingStorageResponse.ReadOnly =
    zio.aws.storagegateway.model.AddWorkingStorageResponse.wrap(buildAwsValue())
}
object AddWorkingStorageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.AddWorkingStorageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.AddWorkingStorageResponse =
      zio.aws.storagegateway.model
        .AddWorkingStorageResponse(gatewayARN.map(value => value))
    def gatewayARN: Option[GatewayARN]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.AddWorkingStorageResponse
  ) extends zio.aws.storagegateway.model.AddWorkingStorageResponse.ReadOnly {
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.AddWorkingStorageResponse
  ): zio.aws.storagegateway.model.AddWorkingStorageResponse.ReadOnly =
    new Wrapper(impl)
}
