package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class JoinDomainResponse(
    gatewayARN: Option[GatewayARN] = None,
    activeDirectoryStatus: Option[
      zio.aws.storagegateway.model.ActiveDirectoryStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.JoinDomainResponse = {
    import JoinDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.JoinDomainResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(activeDirectoryStatus.map(value => value.unwrap))(
        _.activeDirectoryStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.JoinDomainResponse.ReadOnly =
    zio.aws.storagegateway.model.JoinDomainResponse.wrap(buildAwsValue())
}
object JoinDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.JoinDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.JoinDomainResponse =
      zio.aws.storagegateway.model.JoinDomainResponse(
        gatewayARN.map(value => value),
        activeDirectoryStatus.map(value => value)
      )
    def gatewayARN: Option[GatewayARN]
    def activeDirectoryStatus
        : Option[zio.aws.storagegateway.model.ActiveDirectoryStatus]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getActiveDirectoryStatus: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.ActiveDirectoryStatus
    ] =
      AwsError.unwrapOptionField("activeDirectoryStatus", activeDirectoryStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.JoinDomainResponse
  ) extends zio.aws.storagegateway.model.JoinDomainResponse.ReadOnly {
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val activeDirectoryStatus
        : Option[zio.aws.storagegateway.model.ActiveDirectoryStatus] = scala
      .Option(impl.activeDirectoryStatus())
      .map(value =>
        zio.aws.storagegateway.model.ActiveDirectoryStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.JoinDomainResponse
  ): zio.aws.storagegateway.model.JoinDomainResponse.ReadOnly = new Wrapper(
    impl
  )
}
