package zio.aws.storagegateway.model
import java.lang.Integer
import zio.aws.storagegateway.model.primitives.{
  Host,
  DomainUserName,
  OrganizationalUnit,
  TimeoutInSeconds,
  DomainName,
  GatewayARN,
  DomainUserPassword
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class JoinDomainRequest(
    gatewayARN: GatewayARN,
    domainName: DomainName,
    organizationalUnit: Option[OrganizationalUnit] = None,
    domainControllers: Option[Iterable[Host]] = None,
    timeoutInSeconds: Option[TimeoutInSeconds] = None,
    userName: DomainUserName,
    password: DomainUserPassword
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.JoinDomainRequest = {
    import JoinDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.JoinDomainRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        organizationalUnit.map(value =>
          OrganizationalUnit.unwrap(value): java.lang.String
        )
      )(_.organizationalUnit)
      .optionallyWith(
        domainControllers.map(value =>
          value.map { item =>
            Host.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.domainControllers)
      .optionallyWith(
        timeoutInSeconds.map(value => TimeoutInSeconds.unwrap(value): Integer)
      )(_.timeoutInSeconds)
      .userName(DomainUserName.unwrap(userName): java.lang.String)
      .password(DomainUserPassword.unwrap(password): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.JoinDomainRequest.ReadOnly =
    zio.aws.storagegateway.model.JoinDomainRequest.wrap(buildAwsValue())
}
object JoinDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.JoinDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.JoinDomainRequest =
      zio.aws.storagegateway.model.JoinDomainRequest(
        gatewayARN,
        domainName,
        organizationalUnit.map(value => value),
        domainControllers.map(value => value),
        timeoutInSeconds.map(value => value),
        userName,
        password
      )
    def gatewayARN: GatewayARN
    def domainName: DomainName
    def organizationalUnit: Option[OrganizationalUnit]
    def domainControllers: Option[List[Host]]
    def timeoutInSeconds: Option[TimeoutInSeconds]
    def userName: DomainUserName
    def password: DomainUserPassword
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getOrganizationalUnit: ZIO[Any, AwsError, OrganizationalUnit] =
      AwsError.unwrapOptionField("organizationalUnit", organizationalUnit)
    def getDomainControllers: ZIO[Any, AwsError, List[Host]] =
      AwsError.unwrapOptionField("domainControllers", domainControllers)
    def getTimeoutInSeconds: ZIO[Any, AwsError, TimeoutInSeconds] =
      AwsError.unwrapOptionField("timeoutInSeconds", timeoutInSeconds)
    def getUserName: ZIO[Any, Nothing, DomainUserName] = ZIO.succeed(userName)
    def getPassword: ZIO[Any, Nothing, DomainUserPassword] =
      ZIO.succeed(password)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.JoinDomainRequest
  ) extends zio.aws.storagegateway.model.JoinDomainRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val domainName: DomainName =
      zio.aws.storagegateway.model.primitives.DomainName(impl.domainName())
    override val organizationalUnit: Option[OrganizationalUnit] = scala
      .Option(impl.organizationalUnit())
      .map(value =>
        zio.aws.storagegateway.model.primitives.OrganizationalUnit(value)
      )
    override val domainControllers: Option[List[Host]] = scala
      .Option(impl.domainControllers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.primitives.Host(item)
        }.toList
      )
    override val timeoutInSeconds: Option[TimeoutInSeconds] = scala
      .Option(impl.timeoutInSeconds())
      .map(value =>
        zio.aws.storagegateway.model.primitives.TimeoutInSeconds(value)
      )
    override val userName: DomainUserName =
      zio.aws.storagegateway.model.primitives.DomainUserName(impl.userName())
    override val password: DomainUserPassword =
      zio.aws.storagegateway.model.primitives
        .DomainUserPassword(impl.password())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.JoinDomainRequest
  ): zio.aws.storagegateway.model.JoinDomainRequest.ReadOnly = new Wrapper(impl)
}
