package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{SMBGuestPassword, GatewayARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SetSmbGuestPasswordRequest(
    gatewayARN: GatewayARN,
    password: SMBGuestPassword
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.SetSmbGuestPasswordRequest = {
    import SetSmbGuestPasswordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.SetSmbGuestPasswordRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .password(SMBGuestPassword.unwrap(password): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.SetSmbGuestPasswordRequest.ReadOnly =
    zio.aws.storagegateway.model.SetSmbGuestPasswordRequest
      .wrap(buildAwsValue())
}
object SetSmbGuestPasswordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.SetSmbGuestPasswordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.SetSmbGuestPasswordRequest =
      zio.aws.storagegateway.model
        .SetSmbGuestPasswordRequest(gatewayARN, password)
    def gatewayARN: GatewayARN
    def password: SMBGuestPassword
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getPassword: ZIO[Any, Nothing, SMBGuestPassword] = ZIO.succeed(password)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.SetSmbGuestPasswordRequest
  ) extends zio.aws.storagegateway.model.SetSmbGuestPasswordRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val password: SMBGuestPassword =
      zio.aws.storagegateway.model.primitives.SMBGuestPassword(impl.password())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.SetSmbGuestPasswordRequest
  ): zio.aws.storagegateway.model.SetSmbGuestPasswordRequest.ReadOnly =
    new Wrapper(impl)
}
