package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateSmbFileShareVisibilityRequest(
    gatewayARN: GatewayARN,
    fileSharesVisible: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareVisibilityRequest = {
    import UpdateSmbFileShareVisibilityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareVisibilityRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .fileSharesVisible(fileSharesVisible: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateSmbFileShareVisibilityRequest.ReadOnly =
    zio.aws.storagegateway.model.UpdateSmbFileShareVisibilityRequest
      .wrap(buildAwsValue())
}
object UpdateSmbFileShareVisibilityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareVisibilityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.UpdateSmbFileShareVisibilityRequest =
      zio.aws.storagegateway.model
        .UpdateSmbFileShareVisibilityRequest(gatewayARN, fileSharesVisible)
    def gatewayARN: GatewayARN
    def fileSharesVisible: Boolean
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getFileSharesVisible: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(fileSharesVisible)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareVisibilityRequest
  ) extends zio.aws.storagegateway.model.UpdateSmbFileShareVisibilityRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val fileSharesVisible: Boolean = impl.fileSharesVisible(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareVisibilityRequest
  ): zio.aws.storagegateway.model.UpdateSmbFileShareVisibilityRequest.ReadOnly =
    new Wrapper(impl)
}
